<?php
/**
 * Single Event Meta (Organizer) Template
 *
 * Override this template in your own theme by creating a file at:
 * [your-theme]/tribe-events/modules/meta/organizer.php
 *
 * @package TribeEventsCalendar
 * @version 4.6.19
 */

$organizer_ids = tribe_get_organizer_ids();
$multiple = count( $organizer_ids ) > 1;

$phone = tribe_get_organizer_phone();
$email = tribe_get_organizer_email();
$website = tribe_get_organizer_website_link();
?>

<div class="tribe-events-meta-group tribe-events-meta-group-organizer">
	<h2 class="tribe-events-single-section-title"><?php echo tribe_get_organizer_label( ! $multiple ); ?></h2>
	<div class="clearfix">
		<?php
		do_action( 'tribe_events_single_meta_organizer_section_start' );

		foreach ( $organizer_ids as $organizer ) {
			if ( ! $organizer ) {
				continue;
			}

			?>
			<div class="tribe-organizer meta-item">
				<?php echo tribe_get_organizer_link( $organizer ) ?>
			</div>
			<?php
		}

		if ( ! $multiple ) { // only show organizer details if there is one
			if ( ! empty( $phone ) ) {
				?>
				<div class="tribe-organizer-tel meta-item">
					<span class="icon">
						<svg enable-background="new 0 0 512 512" viewBox="0 0 512 512" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
							<path d="m492.56 400.56-100.32-100.32c-11.976-11.975-31.458-11.975-43.435 0l-26.088 26.088c-8.174 8.174-10.758 19.845-7.773 30.241l-9.851 9.851c-6.99 6.998-50.523-3.741-103.14-56.363-52.614-52.613-63.356-96.139-56.366-103.14 0-2e-3 2e-3 -2e-3 2e-3 -2e-3l9.852-9.851c2.781 0.799 5.651 1.207 8.523 1.207 7.865 0 15.729-2.993 21.718-8.98l26.088-26.088c11.975-11.975 11.975-31.458 0-43.434l-100.32-100.32c-5.8-5.8-13.513-8.994-21.716-8.994-8.205 0-15.915 3.196-21.716 8.994l-26.09 26.09c-8.174 8.174-10.758 19.846-7.773 30.241 0 0-8.344 8.424-8.759 8.956-27.753 30.849-32.96 79.418-14.561 137.49 18.017 56.857 56.857 117.09 109.37 169.6 52.508 52.508 112.74 91.348 169.6 109.37 22.84 7.237 44.207 10.823 63.61 10.823 31.813 0 58.337-9.648 77.35-28.66l5.474-5.474c2.74 0.788 5.602 1.213 8.532 1.213 8.205 0 15.917-3.196 21.716-8.994l26.09-26.09c11.975-11.975 11.975-31.459 1e-3 -43.435zm-402.84-359.4 100.32 100.32-26.074 26.102-100.34-100.34 26.089-26.09zm319.31 420.47-5e-3 5e-3c-22.094 22.091-61.146 25.74-109.96 10.27-52.252-16.558-108.06-52.714-157.16-101.81-49.093-49.092-85.249-104.9-101.81-157.16-15.47-48.817-11.821-87.87 10.275-109.97l2.772-2.772 77.857 77.856-7.141 7.141c-5e-3 5e-3 -9e-3 0.011-0.015 0.017-29.585 29.622 5.963 96.147 56.378 146.56 37.734 37.734 84.493 67.14 118.05 67.14 11.284 0 21.076-3.325 28.528-10.778l7.141-7.141 77.857 77.856-2.775 2.773zm35.723-13.255-100.32-100.32 26.088-26.088 100.32 100.32s-26.079 26.099-26.088 26.09z"/>
							<path d="m388.82 123.18c-29.209-29.209-68.042-45.294-109.34-45.293-8.481 0-15.356 6.875-15.356 15.356s6.876 15.356 15.356 15.356c33.1-2e-3 64.219 12.89 87.628 36.297 23.406 23.406 36.295 54.525 36.294 87.624 0 8.481 6.875 15.358 15.356 15.358 8.48 0 15.356-6.875 15.356-15.354 1e-3 -41.304-16.085-80.135-45.29-109.34z"/>
							<path d="m443.9 68.107c-43.923-43.921-102.32-68.109-164.43-68.107-8.481 0-15.356 6.876-15.356 15.356 0 8.481 6.876 15.356 15.356 15.356 53.907-2e-3 104.59 20.992 142.71 59.111 38.118 38.118 59.111 88.799 59.11 142.71 0 8.481 6.875 15.356 15.356 15.356 8.48 0 15.356-6.875 15.356-15.354 2e-3 -62.112-24.186-120.5-68.104-164.42z"/>
							<path d="m333.74 178.26c-14.706-14.706-33.465-22.477-54.256-22.477h-6e-3c-8.481 2e-3 -15.356 6.876-15.354 15.358 2e-3 8.481 6.878 15.356 15.358 15.354h5e-3c12.644 0 23.593 4.536 32.539 13.481 8.819 8.82 13.481 20.075 13.479 32.544-2e-3 8.481 6.875 15.356 15.354 15.358h2e-3c8.481 0 15.354-6.875 15.356-15.354 1e-3 -20.792-7.77-39.556-22.477-54.264z"/>
						</svg>
					</span>
					<?php echo esc_html( $phone ); ?>
				</div>
				<?php
			}//end if

			if ( ! empty( $email ) ) {
				?>
				<div class="tribe-organizer-email meta-item">
					<span class="icon">
						<svg enable-background="new 0 0 512 512" viewBox="0 0 512 512" xml:space="preserve" xmlns="http://www.w3.org/2000/svg">
							<path d="m511.61 197.6c-1e-3 -0.77-0.173-1.933-0.472-2.603-0.787-2.854-2.536-5.461-5.154-7.281l-73.292-50.948v-54.616c0-7.24-5.872-13.112-13.112-13.112h-84.319l-71.743-49.878c-4.484-3.121-10.437-3.134-14.935-0.026l-72.206 49.904h-83.95c-7.242 0-13.112 5.872-13.112 13.112v53.973l-73.648 50.901c-3.623 2.504-5.583 6.507-5.645 10.6-4e-3 0.077-0.021 0.15-0.021 0.23l0.391 284.24c5e-3 3.477 1.391 6.81 3.852 9.266 2.458 2.451 5.788 3.827 9.26 3.827h0.018l485.38-0.667c7.24-0.01 13.104-5.889 13.094-13.13l-0.391-283.79zm-78.919-28.893 41.898 29.118-41.898 29.128v-58.246zm-176.68-122.82 33.31 23.156h-66.812l33.502-23.156zm-150.48 49.381h300.93v149.92l-101.04 70.242-41.194-31.954c-0.064-0.05-0.119-0.081-0.181-0.126-4.604-3.454-11.116-3.581-15.894 0.126l-41.493 32.185-101.13-69.893v-150.5zm-26.224 72.738v59.64l-43.146-29.819 43.146-29.821zm-53.056 54.864 158.67 109.66-158.35 122.82-0.32-232.48zm25.617 246.04 204.32-158.48 203.59 157.92-407.92 0.561zm275.27-136.64 158.28-110.04 0.32 233.06-158.6-123.02z"/>
							<path d="m344.77 147.71h-177.54c-7.24 0-13.112 5.872-13.112 13.112s5.872 13.112 13.112 13.112h177.54c7.242 0 13.112-5.872 13.112-13.112s-5.87-13.112-13.112-13.112z"/>
							<path d="m344.77 215.9h-177.54c-7.24 0-13.112 5.872-13.112 13.112s5.872 13.112 13.112 13.112h177.54c7.242 0 13.112-5.872 13.112-13.112s-5.87-13.112-13.112-13.112z"/>
						</svg>
					</span>
					<?php echo esc_html( $email ); ?>
				</div>
				<?php
			}//end if

			if ( ! empty( $website ) ) {
				?>
				<div class="tribe-organizer-url meta-item margin-bottom-0">
					<span class="icon">
						<svg width="480pt" height="480pt" viewBox="0 0 480 480" xmlns="http://www.w3.org/2000/svg">
							<path d="m240 0c-132.55 0-240 107.45-240 240s107.45 240 240 240 240-107.45 240-240c-0.14844-132.48-107.52-239.85-240-240zm207.57 324.08-68.254 11.777c7.8125-28.652 12.031-58.164 12.559-87.855h71.93c-0.90234 26.117-6.3984 51.871-16.234 76.078zm-431.37-76.078h71.93c0.52734 29.691 4.7461 59.203 12.559 87.855l-68.254-11.777c-9.8359-24.207-15.332-49.961-16.234-76.078zm16.234-92.078 68.254-11.777c-7.8125 28.652-12.031 58.164-12.559 87.855h-71.93c0.90234-26.117 6.3984-51.871 16.234-76.078zm215.57-27.473c28.746 0.36719 57.422 2.9844 85.762 7.832l28.238 4.8711c8.6758 29.523 13.344 60.078 13.879 90.848h-127.88zm88.488-7.9375c-29.238-4.9961-58.828-7.6953-88.488-8.0625v-96c45.863 4.4062 85.703 46.398 108.28 107.51zm-104.49-8.0625c-29.66 0.36719-59.242 3.0664-88.48 8.0625l-19.801 3.4258c22.578-61.129 62.418-103.14 108.28-107.52zm-85.754 23.832c28.336-4.8477 57.008-7.4648 85.754-7.832v103.55h-127.88c0.53516-30.77 5.2031-61.324 13.879-90.848zm-42.125 111.72h127.88v103.55c-28.746-0.36719-57.422-2.9844-85.762-7.832l-28.238-4.8711c-8.6758-29.523-13.344-60.078-13.879-90.848zm39.391 111.49c29.238 5.0039 58.824 7.7148 88.488 8.1055v96c-45.863-4.4102-85.703-46.402-108.28-107.52zm104.49 8.1055c29.66-0.39062 59.242-3.1016 88.48-8.1055l19.801-3.4258c-22.578 61.129-62.418 103.14-108.28 107.52zm85.754-23.875c-28.336 4.8477-57.008 7.4648-85.754 7.832v-103.55h127.88c-0.53516 30.77-5.2031 61.324-13.879 90.848zm58.117-111.72c-0.52734-29.691-4.7461-59.203-12.559-87.855l68.254 11.777c9.8359 24.207 15.332 49.961 16.234 76.078zm47.602-93.711-65.426-11.289c-11.762-38.371-33.766-72.809-63.648-99.602 55.879 18.648 102.22 58.457 129.07 110.89zm-269.87-110.89c-29.883 26.793-51.887 61.23-63.648 99.602l-65.426 11.289c26.855-52.434 73.195-92.242 129.07-110.89zm-129.07 314.31 65.426 11.289c11.762 38.371 33.766 72.809 63.648 99.602-55.879-18.648-102.22-58.457-129.07-110.89zm269.87 110.89c29.883-26.793 51.887-61.23 63.648-99.602l65.426-11.289c-26.855 52.434-73.195 92.242-129.07 110.89z"/>
						</svg>
					</span>
					<?php echo wp_kses($website, false); ?>
				</div>
				<?php
			}//end if
		}//end if

		do_action( 'tribe_events_single_meta_organizer_section_end' );
		?>
	</div>
</div>
