<?php
Redux::setSection( $opt_name, array(
   'icon'   => 'el-icon-shopping-cart',
   'title'  => esc_html__('Product Options', 'kitecx'),
   'fields' => array(
      array(
        'id'        => 'products_per_page',
        'type'      => 'text',
        'title'     => esc_html__('Products Per Page', 'kitecx'),
        'subtitle'  => esc_html__('Number value.', 'kitecx'),
        'desc'      => esc_html__('The amount of products you would like to show per page on shop/category pages.', 'kitecx'),
        'validate'  => 'numeric',
        'default'   => '24'
      )       
   )
));

Redux::setSection( $opt_name, array(
   'icon'         => 'el-icon-shopping-cart',
   'title'        => esc_html__('Shop Options', 'kitecx'),
   'subsection'   => true,
   'fields'       => array(
      array(
         'id'        => 'product_display_layout',
         'type'      => 'select',
         'title'     => esc_html__('Default Product Display Layout', 'kitecx'),
         'subtitle'  => esc_html__('Choose the default product display layout for WooCommerce shop/category pages.', 'kitecx'),
         'options'   => array(
            'grid'   => 'Grid',
            'list'   => 'List',
        ),
        'default' => 'standard'
      ),
      array(
         'id'        => 'product_columns_lg',
         'type'      => 'select',
         'title'     => esc_html__('Display Columns for Large Screen', 'kitecx'),
         'subtitle'  => esc_html__('Choose the number of columns to display on shop/category pages.', 'kitecx'),
         'options'   => array(
            '1'      => '1',
            '2'      => '2',
            '3'      => '3',
            '4'      => '4',
            '5'      => '5',
            '6'      => '6',
         ),
         'default'   => '3'
      ),

      array(
         'id'        => 'product_columns_md',
         'type'      => 'select',
         'title'     => esc_html__('Display Columns for Medium Screen', 'kitecx'),
         'subtitle'  => esc_html__('Choose the number of columns to display on shop/category pages.', 'kitecx'),
         'options'   => array(
            '1'      => '1',
            '2'      => '2',
            '3'      => '3',
            '4'      => '4',
            '5'      => '5',
            '6'      => '6',
         ),
         'default'   => '3'
      ),

      array(
         'id'        => 'product_columns_sm',
         'type'      => 'select',
         'title'     => esc_html__('Display Columns for Small Screen', 'kitecx'),
         'subtitle'  => esc_html__('Choose the number of columns to display on shop/category pages.', 'kitecx'),
         'options'   => array(
            '1'      => '1',
            '2'      => '2',
            '3'      => '3',
            '4'      => '4',
            '5'      => '5',
            '6'      => '6',
         ),
         'default'   => '2'
      ),

      array(
         'id'        => 'product_columns_xs',
         'type'      => 'select',
         'title'     => esc_html__('Display Columns for Extra Small Screen', 'kitecx'),
         'subtitle'  => esc_html__('Choose the number of columns to display on shop/category pages.', 'kitecx'),
         'options'   => array(
            '1'      => '1',
            '2'      => '2',
            '3'      => '3',
            '4'      => '4',
            '5'      => '5',
            '6'      => '6',
         ),
         'default'   => '1'
      ),

      array(
         'id'        => 'woo_sidebar_config',
         'type'      => 'select',
         'title'     => esc_html__('WooCommerce Sidebar Config', 'kitecx'),
         'subtitle'  => esc_html__('Choose the sidebar config for WooCommerce shop/category pages.', 'kitecx'),
         'options'   => array(
           'no-sidebars'     => 'No Sidebars',
           'left-sidebar'    => 'Left Sidebar',
           'right-sidebar'   => 'Right Sidebar'
         ),
         'default' => 'no-sidebars'
      ),
      array(
         'id'        => 'woo_left_sidebar',
         'type'      => 'select',
         'title'     => esc_html__('WooCommerce Left Sidebar', 'kitecx'),
         'subtitle'  => esc_html__('Choose the left sidebar for WooCommerce shop/category pages.', 'kitecx'),
         'data'      => 'sidebars',
         'default'   => 'woocommerce_sidebar'
      ),
      array(
         'id'        => 'woo_right_sidebar',
         'type'      => 'select',
         'title'     => esc_html__('WooCommerce Right Sidebar', 'kitecx'),
         'subtitle'  => esc_html__('Choose the right sidebar for WooCommerce shop/category pages.', 'kitecx'),
         'data'      => 'sidebars',
         'default'   => 'woocommerce_sidebar'
      ),
      array(
         'id'     => 'woo_shop_divide_0',
         'type'   => 'divide'
      ),
      array(
         'id'        => 'woo_breadcrumb_show_title',
         'type'      => 'button_set',
         'title'     => esc_html__('Breadcrumb Display Title Page', 'kitecx'),
         'options'   => array(
            1 => esc_html__('Enable', 'kitecx'),
            0 => esc_html__('Disable', 'kitecx')
         ),
         'default'   => 1
      ),
      array(
         'id'        => 'woo_breadcrumb_padding_top',
         'type'      => 'slider',
         'title'     => esc_html__('Breadcrumb Padding Top', 'kitecx'),
         'default'   => 110,
         'min'       => 50,
         'max'       => 500,
         'step'      => 1,
         'display_value' => 'text',
      ),
      array(
         'id'        => 'woo_breadcrumb_padding_bottom',
         'type'      => 'slider',
         'title'     => esc_html__('Breadcrumb Padding Top', 'kitecx'),
         'default'   => 100,
         'min'       => 50,
         'max'       => 500,
         'step'      => 1,
         'display_value' => 'text',
      ),
      array(
         'id'        => 'woo_breadcrumb_background_color',
         'type'      => 'color',
         'title'     => esc_html__('Background Overlay Color', 'kitecx'),
         'default'   => ''
      ),
      array(
         'id'        => 'woo_breadcrumb_background_opacity',
         'type'      => 'slider',
         'title'     => esc_html__('Breadcrumb Ovelay Color Opacity', 'kitecx'),
         'default'   => 50,
         'min'       => 0,
         'max'       => 100,
         'step'      => 2,
         'display_value' => 'text',
      ),
      array(
         'id'        => 'woo_breadcrumb_image',
         'type'      => 'button_set',
         'title'     => esc_html__('Breadcrumb Image', 'kitecx'),
         'options'   => array( 
            1 => esc_html__('Enable', 'kitecx'),
            0 => esc_html__('Disable', 'kitecx')
         ),
         'default'   => 'enable'
      ),
      array(
         'id'        => 'woo_breadcrumb_background_image',
         'type'      => 'media',
         'url'       => true,
         'title'     => esc_html__('Breadcrumb Background Image', 'kitecx'),
         'default'   => '',
         'required'  => array('woo_breadcrumb_image', '=', 1 )
      ),
      array(
         'id'        => 'woo_breadcrumb_text_stype',
         'type'      => 'select',
         'title'     => esc_html__('Breadcrumb Text Stype', 'kitecx'),
         'options'   => 
         array(
            'text-light'     => esc_html__('Light', 'kitecx'),
            'text-dark'      => esc_html__('Dark', 'kitecx')
         ),
         'default' => 'text-light'
      ),
      array(
         'id'        => 'woo_breadcrumb_text_align',
         'type'      => 'select',
         'title'     => esc_html__('Breadcrumb Text Align', 'kitecx'),
         'options'   => 
         array(
            'text-left'      => esc_html__('Left', 'kitecx'),
            'text-center'    => esc_html__('Center', 'kitecx'),
            'text-right'     => esc_html__('Right', 'kitecx')
         ),
         'default' => 'text-center'
      )
   )
));

Redux::setSection( $opt_name, array(
   'icon'         => 'el-icon-shopping-cart',
   'title'        => esc_html__('Product Options', 'kitecx'),
   'subsection'   => true,
   'fields'       => array(
      array(
         'id'        => 'upsell_heading_text',
         'type'      => 'text',
         'title'     => esc_html__('Upsell Heading Text', 'kitecx'),
         'default'   => esc_html__('Complete the look', 'kitecx')
      ),
      array(
         'id'        => 'related_heading_text',
         'type'      => 'text',
         'title'     => esc_html__('Related Heading Text', 'kitecx'),
         'default'   => esc_html__('Related Products', 'kitecx')
      )
   )
));