<?php
Redux::setSection( $opt_name, array(
   'title' => esc_html__('General Options', 'kitecx'),
   'icon' => 'el-icon-wrench',
   'fields' => array(
      array(
         'id' => 'skin_color',
         'type' => 'select',
         'title' => esc_html__('Skin Color', 'kitecx'),
         'options' => array(
            '' => 'Default',
            'blue'          => 'Blue',
            'brown'         => 'Brown',
            'green'         => 'Green',
            'orange'        => 'Orange',
            'pink'          => 'Pink',
            'purple'        => 'Purple',
            'red'           => 'Red',
            'turquoise'     => 'Turquoise',
            'yellow'        => 'Yellow'
         ),
         'default'         => ''
      ),
      array(
         'id'           => 'color_theme',
         'type'         => 'color',
         'title'        => esc_html__( 'Custom Color Theme', 'kitecx' ),
         'desc'         => esc_html__( 'Used custom color theme instead of Skin Colors Available.', 'kitecx' ),
         'default'      => '',
         'transparent'  => false,
         'validate'     => 'color'
      ),
      array(
         'id'           => 'page_layout',
         'type'         => 'button_set',
         'title'        => esc_html__('Page Layout', 'kitecx'),
         'subtitle'     => esc_html__('Select the page layout type', 'kitecx'),
         'options'      => array(
            'boxed'     => esc_html__('Boxed', 'kitecx'),
            'fullwidth' => esc_html__('Fullwidth', 'kitecx')
         ),
         'default' => 'fullwidth'
      ),
      array(
         'id'        => 'enable_backtotop',
         'type'      => 'button_set',
         'title'     => esc_html__('Enable Back To Top', 'kitecx'),
         'subtitle'  => esc_html__('Enable the back to top button that appears in the bottom right corner of the screen.', 'kitecx'),
         'options'   => array(
            '1' => esc_html__('On', 'kitecx'),
            '0' => esc_html__('Off', 'kitecx')
         ),
         'default'   => '1'
      ),
      array(
        'id' => 'map_api_key',
        'type' => 'text',
        'title' => esc_html__('Google Map API key', 'kitecx'),
        'default' => ''
      ),
   )
));