<?php
Redux::setSection( $opt_name, array(
	'title' 	=> esc_html__('Breadcrumb Options', 'kitecx'),
	'icon' 	=> 'el-icon-compass',
	'fields' => array(
		array(
		  	'id' 			=> 'breadcrumb_show_title',
		  	'type' 		=> 'button_set',
		  	'title' 		=> esc_html__('Breadcrumb Display Title Page', 'kitecx'),
		  	'options' 	=> array(
				1 => esc_html__('Enable', 'kitecx'),
				0 => esc_html__('Disable', 'kitecx')
			),
		  	'default' => 1
		),
		array(
		  	'id'        => 'breadcrumb_padding_top',
		  	'type'      => 'slider',
		  	'title'     => esc_html__('Breadcrumb Padding Top', 'kitecx'),
		  	'default'   => 135,
		  	'min'       => 50,
		  	'max'       => 500,
		  	'step'      => 1,
		  	'display_value' => 'text',
		),
		array(
		  	'id'        => 'breadcrumb_padding_bottom',
		  	'type'      => 'slider',
		  	'title'     => esc_html__('Breadcrumb Padding Top', 'kitecx'),
		  	'default'   => 135,
		  	'min'       => 50,
		  	'max'       => 500,
		  	'step'      => 1,
		  	'display_value' => 'text',
		),
		array(
		  	'id' 			=> 'breadcrumb_background_color',
		  	'type' 		=> 'color',
		  	'title' 		=> esc_html__('Background Overlay Color', 'kitecx'),
		  	'default' 	=> '#1F2230'
		),
		array(
		  	'id'        => 'breadcrumb_background_opacity',
		  	'type'      => 'slider',
		  	'title'     => esc_html__('Breadcrumb Ovelay Color Opacity', 'kitecx'),
		  	'default'   => 50,
		  	'min'       => 0,
		  	'max'       => 100,
		  	'step'      => 1,
		  	'display_value' => 'text'
		),
		array(
		  	'id' 			=> 'breadcrumb_image',
		  	'type' 		=> 'button_set',
		  	'title' 		=> esc_html__('Enable Breadcrumb Image', 'kitecx'),
		  	'options' 	=> array(
		  		1 => esc_html__('Enable', 'kitecx'),
		  		0 => esc_html__('Disable', 'kitecx')
		  	),
		  	'default' 	=> 1
		),
		array(
		  	'id' 			=> 'breadcrumb_background_image',
		  	'type' 		=> 'media',
		  	'url' 		=> true,
		  	'title' 		=> esc_html__('Breadcrumb Background Image', 'kitecx'),
		  	'default' 	=> '',
		  	'required'  => array( 'breadcrumb_image', '=', 1 )
		),
		array(
		  	'id'    		=> 'breadcrumb_text_stype',
		  	'type'    	=> 'select',
		  	'title'   	=> esc_html__( 'Breadcrumb Text Stype', 'kitecx' ),
		  	'options' 	=> 
		  	array(
			 	'text-light'     => esc_html__('Light', 'kitecx'),
			 	'text-dark'      => esc_html__('Dark', 'kitecx')
		  	),
		  	'default' => 'text-light'
		),
		array(
		  	'id'    		=> 'breadcrumb_text_align',
		  	'type'    	=> 'select',
		  	'title'   	=> esc_html__( 'Breadcrumb Text Align', 'kitecx' ),
		  	'options' 	=> 
		  	array(
			 	'text-left'      => esc_html__('Left', 'kitecx'),
			 	'text-center'    => esc_html__('Center', 'kitecx'),
			 	'text-right'     => esc_html__('Right', 'kitecx')
		  	),
		  	'default' => 'text-left'
		)
	)
));