<?php
function kitecx_register_meta_boxes(){
	$prefix = 'kitecx_';
	global $meta_boxes, $wp_registered_sidebars;;
	$sidebar = array();
	$sidebar[""] = ' --Default-- ';
	foreach($wp_registered_sidebars as $key => $value){
		$sidebar[$value['id']] = $value['name'];
	}
	$default_options = get_option('kitecx_options');
	
	$meta_boxes = array();

	/* ====== Metabox Post Thumbnail ====== */
	$meta_boxes[] = array(
		'id' 			=> 'gavias_metaboxes_post_thumbnail',
		'title' 		=> esc_html__('Thumbnail', 'kitecx'),
		'pages' 		=> array( 'post' ),
		'context' 	=> 'normal',
		'fields' 	=> array(
			
			// THUMBNAIL IMAGE
			array(
				'name'  => esc_html__('Thumbnail image', 'kitecx'),
				'desc'  => esc_html__('The image that will be used as the thumbnail image.', 'kitecx'),
				'id'    => "{$prefix}thumbnail_image",
				'type'  => 'image_advanced',
				'max_file_uploads' => 1
			),

			// THUMBNAIL VIDEO
			array(
				'name' => esc_html__('Thumbnail video URL', 'kitecx'),
				'id' => $prefix . 'thumbnail_video_url',
				'desc' => esc_html__('Enter the video url for the thumbnail. Only links from Vimeo & YouTube are supported.', 'kitecx'),
				'clone' => false,
				'type'  => 'oembed',
				'std' => '',
			),

			// THUMBNAIL AUDIO
			array(
				'name' => esc_html__('Thumbnail audio URL', 'kitecx'),
				'id' => "{$prefix}thumbnail_audio_url",
				'desc' => esc_html__('Enter the audio url for the thumbnail.', 'kitecx'),
				'clone' => false,
				'type'  => 'oembed',
				'std' => '',
			),

			// THUMBNAIL GALLERY
			array(
				'name'             => esc_html__('Thumbnail gallery', 'kitecx'),
				'desc'             => esc_html__('The images that will be used in the thumbnail gallery.', 'kitecx'),
				'id'               => "{$prefix}thumbnail_gallery",
				'type'             => 'image_advanced',
				'max_file_uploads' => 50,
			),

			// THUMBNAIL LINK TYPE
			array(
				'name' => esc_html__('Thumbnail link type', 'kitecx'),
				'id'   => "{$prefix}thumbnail_link_type",
				'type' => 'select',
				'options' => array(
					'link_to_post'    => esc_html__('Link to item', 'kitecx'),
					'link_to_url'     => esc_html__('Link to URL', 'kitecx'),
					'link_to_url_nw'  => esc_html__('Link to URL (New Window)', 'kitecx'),
					'lightbox_thumb'  => esc_html__('Lightbox to the thumbnail image', 'kitecx'),
					'lightbox_image'  => esc_html__('Lightbox to image (select below)', 'kitecx'),
					'lightbox_video'  => esc_html__('Fullscreen Video Overlay (input below)', 'kitecx')
				),
				'multiple' => false,
				'std'  => 'link-to-post',
				'desc' => esc_html__('Choose what link will be used for the image(s) and title of the item.', 'kitecx')
			),

			// THUMBNAIL LINK URL
			array(
				'name' => esc_html__('Thumbnail link URL', 'kitecx'),
				'id' => $prefix . 'thumbnail_link_url',
				'desc' => esc_html__('Enter the url for the thumbnail link.', 'kitecx'),
				'clone' => false,
				'type'  => 'text',
				'std' => '',
			),

			// THUMBNAIL LINK LIGHTBOX IMAGE
			array(
				'name'  => esc_html__('Thumbnail link lightbox image', 'kitecx'),
				'desc'  => esc_html__('The image that will be used as the lightbox image.', 'kitecx'),
				'id'    => "{$prefix}thumbnail_link_image",
				'type'  => 'thickbox_image'
			),
		)
	);

	/* ====== Metabox Page ====== */
	$meta_boxes[] = array(
		'id'    => 'gavias_metaboxes_page',
		'title' => esc_html__('Page Meta', 'kitecx'),
		'pages' => array( 'page', 'portfolio', 'product', 'post' ),
		'priority'   => 'high',
		'fields' => array(
			array(
				'name' => esc_html__('Full Width( 100% Main Width )', 'kitecx'),
				'id'   => "{$prefix}page_full_width",
				'type' => 'switch',
				'desc' => esc_html__('Turn on to have the main area display at 100% width according to the window size. Turn off to follow site width.', 'kitecx'),
				'std' => 0,
			),
			array(
				'name' => esc_html__('Header', 'kitecx'),
				'id' => $prefix . 'page_header',
				'desc' => esc_html__("You can change header for page if you like's.", 'kitecx'),
				'type'  => 'select',
				'options'   => kitecx_get_headers(),
				'std' => '__default_option_theme',
			),
			array(
				'name'      => esc_html__('Footer', 'kitecx'),
				'id'        => $prefix . 'page_footer',
				'desc'      => esc_html__("You can change footer for page if you like's",'kitecx'),
				'type'      => 'select',
				'options'   =>  kitecx_get_footer(),
				'std'       => '__default_option_theme'
			),
			array(
				'name' => esc_html__('Extra page class', 'kitecx'),
				'id' => $prefix . 'extra_page_class',
				'desc' => esc_html__("If you wish to add extra classes to the body class of the page (for custom css use), then please add the class(es) here.", 'kitecx'),
				'clone' => false,
				'type'  => 'text',
				'std' => '',
			),
		)
	);

	/* ====== Metabox Page Title ====== */
	$meta_boxes[] = array(
		'id' => 'gavias_metaboxes_page_heading',
		'title' => esc_html__('Page Title & Breadcrumb', 'kitecx'),
		'pages' => array( 'post', 'page', 'product', 'portfolio', 'tribe_events', 'gva_team'),
		'context' => 'normal',
		'priority'   => 'high',
		'fields' => array(
		  array(
			 'name' => esc_html__('Remove Title of Page', 'kitecx'),   
			 'id'   => "{$prefix}disable_page_title",
			 'type' => 'switch',
			 'std'  => 0,
		  ),
		  array(
			 'name' => esc_html__('Disable Breadcrumbs', 'kitecx'),
			 'id'   => "{$prefix}no_breadcrumbs",
			 'type' => 'switch',
			 'desc' => esc_html__('Disable the breadcrumbs from under the page title on this page.', 'kitecx'),
			 'std' => 0,
		  ),
		  array(
			 'name' => esc_html__('Breadcrumb Layout', 'kitecx'),
			 'id'   => "{$prefix}breadcrumb_layout",
			 'type' => 'select',
			 'options' => array(
				 'theme_options'     => esc_html__('Default Options in Theme-Settings', 'kitecx'),
				 'page_options'      => esc_html__('Individuals Options This Page', 'kitecx')
			 ),
			 'multiple' => false,
			 'std'  => 'theme_options',
			 'desc' => esc_html__('You can use breadcrumb settings default in Theme-Settings or individuals this page', 'kitecx')
		  ),
		  array(
			 'name'    => esc_html__('Show page title in the breadcrumbs', 'kitecx'),   
			 'id'      => "{$prefix}page_title",
			 'type'    => 'switch',
			 'std'     => 1,
			 'class'   => 'breadcrumb_setting'
		  ),
		  array(
			 'name' 		=> esc_html__('Page Title Override', 'kitecx'),
			 'id' 		=> $prefix . 'page_title_one',
			 'desc' 		=> esc_html__("Enter a custom page title if you'd like.", 'kitecx'),
			 'type'  	=> 'text',
			 'std' 		=> '',
			 'class'   	=> 'breadcrumb_setting'
		  ),
		  array(
			 'name'        => esc_html__( 'Breadcrumb Padding Top (px)', 'kitecx' ),
			 'id'          => "{$prefix}breadcrumb_padding_top",
			 'type'        => 'number',
			 'prefix'      => '',
			 'class'       => 'breadcrumb_setting',
			 'desc'        => esc_html__('Option Padding Top of Breacrumb, set empty = padding default of theme', 'kitecx'),
			 'std'         => kitecx_get_option('breadcrumb_padding_top', '135'),
		  ),
		  array(
			 'name'       => esc_html__( 'Breadcrumb Padding Bottom (px)', 'kitecx' ),
			 'id'         => "{$prefix}breadcrumb_padding_bottom",
			 'type'       => 'number',
			 'prefix'     => 'px',
			 'class'      => 'breadcrumb_setting',
			 'desc'       => esc_html__('Option Padding Bottom of Breacrumb, set empty = padding default of theme', 'kitecx'),
			 'std'        => kitecx_get_option('breadcrumb_padding_bottom', '135'),
		  ),
		  array(
			 'name' 	=> esc_html__( 'Background Overlay Color', 'kitecx' ),
			 'id'   	=> "{$prefix}bg_color_title",
			 'desc' 	=> esc_html__( "Set an overlay color for hero heading image.", 'kitecx' ),
			 'type' 	=> 'color',
			 'class' => 'breadcrumb_setting',
			 'std'  	=> '',
		  ),
		  array(
			 'name'       => esc_html__( 'Overlay Opacity', 'kitecx' ),
			 'id'         => "{$prefix}bg_opacity_title",
			 'desc'       => esc_html__( 'Set the opacity level of the overlay. This will lighten or darken the image depening on the color selected.', 'kitecx' ),
			 'clone'      => false,
			 'type'       => 'slider',
			 'prefix'     => '',
			 'class'   	  => 'breadcrumb_setting',
			 'js_options' => array(
				  'min'  => 0,
				  'max'  => 100,
				  'step' => 1,
			 ),
			 'std'   => '50'
		  ),
		  array(
			 'name'    => esc_html__('Enable Breadcrumb Image', 'kitecx'),
			 'id'      => "{$prefix}image_breadcrumbs",
			 'type'    => 'switch',
			 'class'   => 'breadcrumb_setting',
			 'std'     => 1,
		  ),
		  array(
			 'name'  	=> esc_html__('Breadcrumb Background Image', 'kitecx'),
			 'id'    	=> "{$prefix}page_title_image",
			 'type'  	=> 'image_advanced',
			 'class'   	=> 'breadcrumb_setting',
			 'max_file_uploads' => 1
		  ),
		  array(
			 'name' 		=> esc_html__('Heading Text Style', 'kitecx'),
			 'id'   		=> '{$prefix}page_title_text_style',
			 'type' 		=> 'select',
			 'class'   => 'breadcrumb_setting',
			 'options' => array(
				 'text-light'     => esc_html__('Light', 'kitecx'),
				 'text-dark'      => esc_html__('Dark', 'kitecx')
			 ),
			 'multiple' => false,
			 'std'  		=> kitecx_get_option('breadcrumb_text_stype', 'text-dark'),
			 'desc' 		=> esc_html__('If you uploaded an image in the option above, choose light/dark styling for the text heading text here.', 'kitecx')
		  ),
		  array(
			 'name' 	=> esc_html__('Heading Text Align', 'kitecx'),
			 'id'   	=> "{$prefix}page_title_text_align",
			 'type' 	=> 'select',
			 'class'   => 'breadcrumb_setting',
			 'options' => array(
				 'text-left'      => esc_html__('Left', 'kitecx'),
				 'text-center'    => esc_html__('Center', 'kitecx'),
				 'text-right'     => esc_html__('Right', 'kitecx')
			 ),
			 'multiple' => false,
			 'std'  => kitecx_get_option('breadcrumb_text_align', 'text-center'),
			 'desc' => esc_html__('Choose the text alignment for the hero heading.', 'kitecx')
		  ),
		)
	);

	/* ====== Metabox Page ====== */
	$meta_boxes[] = array(
		'id'    => 'gavias_metaboxes_sidebar_page',
		'title' => esc_html__('Sidebar Options', 'kitecx'),
		'pages' => array( 'post', 'page', 'portfolio','tribe_events' ),
		'priority'   => 'high',
		'fields' => array(
			// SIDEBAR CONFIG
			array(
				'name' => esc_html__('Sidebar configuration', 'kitecx'),
				'id'   => "{$prefix}sidebar_config",
				'type' => 'select',
				'options' => array(
				  ''                   => esc_html__('--Default--', 'kitecx'),
				  'no-sidebars'        => esc_html__('No Sidebars', 'kitecx'),
				  'left-sidebar'       => esc_html__('Left Sidebar', 'kitecx'),
				  'right-sidebar'      => esc_html__('Right Sidebar', 'kitecx'),
				),
				'multiple' => false,
				'std'  => '',
				'desc' => esc_html__('Choose the sidebar configuration for the detail page of this page.', 'kitecx'),
			),
			// LEFT SIDEBAR
			array (
				'name'   	=> esc_html__('Left Sidebar', 'kitecx'),
				 'id'    	=> "{$prefix}left_sidebar",
				 'type' 		=> 'select',
				 'options'  => $sidebar,
				 'std'   	=> ''
			),
			// RIGHT SIDEBAR
			array (
				'name'   	=> esc_html__('Right Sidebar', 'kitecx'),
				'id'    		=> "{$prefix}right_sidebar",
				'type' 		=> 'select',
				'options'  	=> $sidebar,
				'std'   	=> ''
			),
		)
	);

	/* Gallery Meta Box 
  	================================================== */
	$meta_boxes[] = array(
    'id'    => 'metaboxes_portfolio_page',
    'title' => esc_html__('Portfolio Settings', 'kitecx'),
    'pages' => array( 'portfolio' ),
    'priority'   => 'high',
    'fields' => array(
      array (
        'name'   => esc_html__('Gallery Images', 'kitecx'),
        'id'    => "{$prefix}gallery_images",
        'type'             => 'image_advanced',
        'max_file_uploads' => 50,
      ),
    )
  );


	/* ====== Metabox Team ====== */
  	$meta_boxes[] = array(
	 	'id'    		=> 'metaboxes_team_page',
	 	'title' 		=> esc_html__('Team Settings', 'kitecx'),
	 	'pages' 		=> array( 'gva_team' ),
	 	'priority'  => 'high',
	 	'fields' 	=> array(
			array (
			  	'name'   => esc_html__('Position', 'kitecx'),
			  	'id'    	=> "{$prefix}team_position",
			  	'type' 	=> 'text',
			  	'std'   	=> ''
			),
			array (
			  	'name'   => esc_html__('Quote', 'kitecx'),
			  	'id'    	=> "{$prefix}team_quote",
			  	'type' 	=> 'textarea',
			  	'std'   	=> ''
			),
			array(
			  	'name'   => esc_html__('Email', 'kitecx'),
			  	'id'    	=> "{$prefix}team_email",
			  	'type' 	=> 'text',
			  	'std'   	=> ''
			),
			array(
			  	'name'   => esc_html__('Phone', 'kitecx'),
			  	'id'    	=> "{$prefix}team_phone",
			  	'type' 	=> 'text',
			  	'std'   	=> ''
			),
			array(
			  	'name'   => esc_html__('Address', 'kitecx'),
			  	'id'    	=> "{$prefix}team_address",
			  	'type' 	=> 'text',
			  	'std'   	=> ''
			)
		)
  );

  	/* ====== Metabox Header Builder ====== */
  	$meta_boxes[] = array(
	 	'id'    		=> 'metaboxes_header_builder',
	 	'title' 		=> esc_html__('Header Builder', 'kitecx'),
	 	'pages' 		=> array( 'gva_header' ),
	 	'priority' 	=> 'high',
	 	'fields' 	=> array(
			array(
		  		'name' => esc_html__('Enable Background Black', 'kitecx'),
		  		'id'   => "{$prefix}header_bg_black",
		  		'type' => 'switch',
		  		'desc' => esc_html__('It will display background black when builder header.', 'kitecx'),
		  		'std'  => 0,
			),
			array(
			  	'name' => esc_html__('Full Width( 100% Main Width )', 'kitecx'),
			  	'id'   => "{$prefix}header_full_width",
			  	'type' => 'switch',
			  	'desc' => esc_html__('Turn on to have the main area display at 100% width according to the window size. Turn off to follow site width.', 'kitecx'),
			  	'std'  => 0,
	  		),
			array(
			  	'name' => esc_html__('Position Styling', 'kitecx'),
			  	'id'   => "{$prefix}header_position",
			  	'type' => 'select',
			  	'options' => array(
				 	'relative'      => esc_html__('Relative', 'kitecx'),
				 	'absolute'      => esc_html__('Absolute', 'kitecx'),
			  	),
		  		'std' 	  => 'relative',
		  		'multiple' => false,
			)
	 	)
  	);

	return $meta_boxes;
 }  
  /********************* META BOX REGISTERING ***********************/
  add_filter( 'rwmb_meta_boxes', 'kitecx_register_meta_boxes' , 99 );

