<?php
function kitecx_custom_color_theme(){
   $theme_color = kitecx_get_option('color_theme', '');
   if( !empty($theme_color) ){ 
      ob_start();

   /* ----- Style Color Theme ----- */
?>

<?php if( !empty($theme_color) ){ ?>
a:hover{
   color: <?php echo esc_attr($theme_color) ?>;
}
.page-links > a:hover, .page-links > span:not(.page-links-title):hover{
   border-color: 1px solid <?php echo esc_attr($theme_color) ?>;
}
.page-links > span:not(.page-links-title){
   border: 1px solid <?php echo esc_attr($theme_color) ?>;
}
.page-links .post-page-numbers:hover{
   border-color: <?php echo esc_attr($theme_color) ?>;
}
.page-links span.post-page-numbers{
   border-color: <?php echo esc_attr($theme_color) ?>;
}
blockquote{
   border-left: 2px solid <?php echo esc_attr($theme_color) ?> !important;
}
.wp-block-pullquote.is-style-solid-color{
   border-left: 2px solid <?php echo esc_attr($theme_color) ?> !important;
}
ul.feature-list > li:after, ul.list-style-1 > li:after{
   color: <?php echo esc_attr($theme_color) ?>;
}
ul.list-style-2 > li{
   color: <?php echo esc_attr($theme_color) ?>;
}
.pager .paginations a:hover{
   color: <?php echo esc_attr($theme_color) ?>;
   border-color: <?php echo esc_attr($theme_color) ?>;
}
.pager .paginations a.active{
   background: <?php echo esc_attr($theme_color) ?>;
   border-color: <?php echo esc_attr($theme_color) ?>;
}
.bg-theme{
   background: <?php echo esc_attr($theme_color) ?> !important;
}
.bg-theme-2{
   background: <?php echo esc_attr($theme_color) ?> !important;
}
.text-theme{
   color: <?php echo esc_attr($theme_color) ?> !important;
}
.hover-color-theme a:hover{
   color: <?php echo esc_attr($theme_color) ?> !important;
}
.hover-color-theme-2 a:hover{
   color: <?php echo esc_attr($theme_color) ?> !important;
}
.btn:after, .btn-theme:after, .btn:after, .btn-white:after, .btn-gray:after, .btn-black:after, .btn-black-2:after, input[type*="submit"]:not(.fa):not(.btn-theme):after, #tribe-events .tribe-events-button:after, .tribe-events-button:after{
   background: <?php echo esc_attr($theme_color) ?>;
}
.btn:hover, .btn-theme:hover, .btn:hover, .btn-white:hover, .btn-gray:hover, .btn-black:hover, .btn-black-2:hover, input[type*="submit"]:not(.fa):not(.btn-theme):hover, #tribe-events .tribe-events-button:hover, .tribe-events-button:hover{
   background: <?php echo esc_attr($theme_color) ?>;
}
.btn-theme{
   background: <?php echo esc_attr($theme_color) ?>;
}
.btn-theme:before{
   background: <?php echo esc_attr($theme_color) ?>;
}
.btn-black:after, input[type*="submit"]:not(.fa):not(.btn-theme):after{
   background: <?php echo esc_attr($theme_color) ?>;
}
.btn-black:hover, input[type*="submit"]:not(.fa):not(.btn-theme):hover{
   background: <?php echo esc_attr($theme_color) ?>;
}
.btn-white:after{
   background: <?php echo esc_attr($theme_color) ?>;
}
.btn-white:hover, .btn-white:focus, .btn-white:active{
   background: <?php echo esc_attr($theme_color) ?>;
}
#tribe-events .tribe-events-button:hover, .tribe-events-button:hover{
   background: <?php echo esc_attr($theme_color) ?>;
}
.btn-inline:hover{
   color: <?php echo esc_attr($theme_color) ?>;
}
.socials a i{
   background: <?php echo esc_attr($theme_color) ?>;
}
.socials-2 li a i:hover{
   color: <?php echo esc_attr($theme_color) ?>;
}
.alert-danger{
   background: <?php echo esc_attr($theme_color) ?>;
}
.desc-slider a{
   color: <?php echo esc_attr($theme_color) ?>;
}
footer .footer-main a:hover{
   color: <?php echo esc_attr($theme_color) ?>;
}
.gva-search .control-search:hover i, .gva-search .control-search:focus i, .gva-search .control-search.search-open i{
   color: <?php echo esc_attr($theme_color) ?>;
}
.header-mobile .topbar-mobile .topbar-left .topbar-information i{
   color: <?php echo esc_attr($theme_color) ?>;
}
.header-default .header-bottom .header-bottom-inner .gsc-search-box .control-search:hover svg{
   fill: <?php echo esc_attr($theme_color) ?>;
}
ul.gva-nav-menu > li .submenu-inner li a:hover, ul.gva-nav-menu > li .submenu-inner li a:focus, ul.gva-nav-menu > li .submenu-inner li a:active, ul.gva-nav-menu > li ul.submenu-inner li a:hover, ul.gva-nav-menu > li ul.submenu-inner li a:focus, ul.gva-nav-menu > li ul.submenu-inner li a:active{
   color: <?php echo esc_attr($theme_color) ?>;
}
.gavias-off-canvas-toggle{
   background: <?php echo esc_attr($theme_color) ?>;
}
#gavias-off-canvas .off-canvas-top .top-social > a:hover{
   background: <?php echo esc_attr($theme_color) ?>;
   border-color: <?php echo esc_attr($theme_color) ?>;
}
#gavias-off-canvas .off-canvas-top .gavias-off-canvas-close:hover{
   background: <?php echo esc_attr($theme_color) ?>;
}
#gavias-off-canvas ul#menu-main-menu > li > a.active > a{
   color: <?php echo esc_attr($theme_color) ?>;
}
#gavias-off-canvas ul#menu-main-menu > li .submenu-inner.dropdown-menu li a:hover, #gavias-off-canvas ul#menu-main-menu > li .submenu-inner.dropdown-menu li a:focus{
   color: <?php echo esc_attr($theme_color) ?>;
}
#gavias-off-canvas ul#menu-main-menu > li .submenu-inner.dropdown-menu li.active > a{
   color: <?php echo esc_attr($theme_color) ?>;
}
.gva-offcanvas-content a:hover{
   color: <?php echo esc_attr($theme_color) ?>;
}
.gva-offcanvas-content .close-canvas a:hover{
   color: <?php echo esc_attr($theme_color) ?>;
}
.gva-offcanvas-content #gva-mobile-menu ul.gva-mobile-menu > li a:hover{
   color: <?php echo esc_attr($theme_color) ?>;
}
.gva-offcanvas-content #gva-mobile-menu ul.gva-mobile-menu > li.menu-item-has-children .caret:hover{
   color: <?php echo esc_attr($theme_color) ?>;
}
.gva-offcanvas-content #gva-mobile-menu ul.gva-mobile-menu > li ul.submenu-inner li a:hover, .gva-offcanvas-content #gva-mobile-menu ul.gva-mobile-menu > li div.submenu-inner li a:hover{
   color: <?php echo esc_attr($theme_color) ?>;
}
.megamenu-main .widget.widget-html ul li strong{
   color: <?php echo esc_attr($theme_color) ?>;
}
.elementor-sidebar-widget .title:before{
   background: <?php echo esc_attr($theme_color) ?>;
}
.bg-row-theme, .bg-col-theme > .elementor-column-wrap, .bg-col-theme > .elementor-widget-wrap{
   background-color: <?php echo esc_attr($theme_color) ?>;
}
.col-bg-theme-inner > .elementor-column-wrap > .elementor-widget-wrap{
   background: <?php echo esc_attr($theme_color) ?>;
}
.elementor-widget-icon-box .elementor-icon-box-icon .elementor-icon{
   color: <?php echo esc_attr($theme_color) ?>;
   fill: <?php echo esc_attr($theme_color) ?>;
}
.elementor-icon-list-items .elementor-icon-list-item .elementor-icon-list-icon{
   color: <?php echo esc_attr($theme_color) ?>;
}
.elementor-icon-list-items .elementor-icon-list-item .elementor-icon-list-icon span, .elementor-icon-list-items .elementor-icon-list-item .elementor-icon-list-text span{
   color: <?php echo esc_attr($theme_color) ?>;
}
.elementor-icon-list-items .elementor-icon-list-item a:hover{
   color: <?php echo esc_attr($theme_color) ?>;
}
.elementor-icon-list-items .elementor-icon-list-item a:hover .elementor-icon-list-text{
   color: <?php echo esc_attr($theme_color) ?>;
}
.post-small .post .cat-links a{
   color: <?php echo esc_attr($theme_color) ?>;
}
.gsc-career .box-content .job-type{
   background: <?php echo esc_attr($theme_color) ?>;
}
.gva-hover-box-carousel .hover-box-item .box-content .box-icon{
   background: <?php echo esc_attr($theme_color) ?>;
}
.gsc-countdown{
   background: <?php echo esc_attr($theme_color) ?>;
}
.gsc-icon-box-group.style-2 .icon-box-item-content .icon-box-item-inner .box-icon i{
   color: <?php echo esc_attr($theme_color) ?>;
}
.gsc-icon-box-group.style-2 .icon-box-item-content .icon-box-item-inner .box-icon svg{
   fill: <?php echo esc_attr($theme_color) ?>;
}
.gsc-icon-box-group.layout-carousel.style-2 .owl-stage-outer .owl-item.center .icon-box-item-content .icon-box-item-inner{
   border-bottom-color: <?php echo esc_attr($theme_color) ?>;
}
.gsc-icon-box-styles.style-1 .icon-box-content:hover .icon-box-content, .gsc-icon-box-styles.style-1 .icon-box-content.active .icon-box-content{
   background: <?php echo esc_attr($theme_color) ?>;
}
.gsc-icon-box-styles.style-2 .box-icon .box-icon-inner i, .gsc-icon-box-styles.style-2 .box-icon .box-icon-inner svg{
   color: <?php echo esc_attr($theme_color) ?>;
   fill: <?php echo esc_attr($theme_color) ?>;
}
.gsc-icon-box-styles.style-2:hover .box-icon i, .gsc-icon-box-styles.style-2:hover .box-icon svg, .gsc-icon-box-styles.style-2.active .box-icon i, .gsc-icon-box-styles.style-2.active .box-icon svg{
   color: <?php echo esc_attr($theme_color) ?> !important;
   fill: <?php echo esc_attr($theme_color) ?> !important;
}
.gsc-icon-box-styles.style-2:hover .bg-image, .gsc-icon-box-styles.style-2.active .bg-image{
   background: <?php echo esc_attr($theme_color) ?>;
}
.milestone-block.style-2 .box-content .milestone-icon .icon{
   color: <?php echo esc_attr($theme_color) ?>;
}
.milestone-block.style-2 .box-content .milestone-icon .icon svg{
   fill: <?php echo esc_attr($theme_color) ?>;
}
.milestone-block.style-3 .box-content .milestone-icon .icon:after{
   background: <?php echo esc_attr($theme_color) ?>;
}
.milestone-block.style-3 .box-content .milestone-content .milestone-number-inner{
   color: <?php echo esc_attr($theme_color) ?>;
}
.gsc-heading .heading-video .video-link{
   background: <?php echo esc_attr($theme_color) ?>;
}
.gsc-heading .title strong{
   color: <?php echo esc_attr($theme_color) ?>;
}
.gsc-heading .title-desc ul > li:before{
   background: <?php echo esc_attr($theme_color) ?>;
}
.gsc-image-content.skin-v2 .box-content .title span{
   color: <?php echo esc_attr($theme_color) ?>;
}
.gsc-image-content.skin-v3 .shape-2{
   background-color: <?php echo esc_attr($theme_color) ?>;
}
.gsc-image-content.skin-v5 .image-second .line-color{
   background: <?php echo esc_attr($theme_color) ?>;
}
.gsc-image-content.skin-v5 .title{
   color: <?php echo esc_attr($theme_color) ?>;
}
.gsc-image-content.skin-v5 .title .box-icon{
   color: <?php echo esc_attr($theme_color) ?>;
   fill: <?php echo esc_attr($theme_color) ?>;
}
.gva-posts-grid .posts-grid-filter ul.nav-tabs > li > a.active{
   color: <?php echo esc_attr($theme_color) ?>;
}
.gva-posts-sticky .gva-content-items .first-post .post .entry-content{
   background: <?php echo esc_attr($theme_color) ?>;
}
.gva-posts-sticky .gva-content-items .first-post .post .entry-content:after{
   background: <?php echo esc_attr($theme_color) ?>;
}
.gva-testimonial-carousel.style-1 .testimonial-item:hover .testimonial-image{
   border-color: <?php echo esc_attr($theme_color) ?>;
}
.gva-testimonial-carousel.style-1 .testimonial-item:hover .testimonial-content-inner .quote-icon{
   color: <?php echo esc_attr($theme_color) ?>;
}
.gva-testimonial-carousel.style-1 .owl-item.first .testimonial-image{
   border-color: <?php echo esc_attr($theme_color) ?>;
}
.gva-testimonial-carousel.style-1 .owl-item.first .testimonial-content-inner .quote-icon{
   color: <?php echo esc_attr($theme_color) ?>;
}
.gva-testimonial-carousel.style-3 .testimonial-item .testimonial-item-content .testimonial-image .icon-quote{
   background: <?php echo esc_attr($theme_color) ?>;
}
.gva-testimonial-carousel.style-3 .testimonial-item .testimonial-item-content:hover .icon-quote{
   background: <?php echo esc_attr($theme_color) ?>;
}
.gva-testimonial-single.style-2 .testimonial-item .testimonial-video .video-link{
   background: <?php echo esc_attr($theme_color) ?>;
}
.gsc-video-box.style-1 .video-inner .video-content .video-action .popup-video{
   color: <?php echo esc_attr($theme_color) ?>;
}
.gsc-video-box.style-2 .video-inner .video-content .video-action .popup-video{
   background: <?php echo esc_attr($theme_color) ?>;
}
.gsc-video-box.style-2 .video-inner .video-content .video-action .popup-video::before{
   border: 1px solid <?php echo esc_attr($theme_color) ?>;
}
.gsc-video-box.style-2 .video-inner .video-content .video-action .popup-video::after{
   border: 1px solid <?php echo esc_attr($theme_color) ?>;
}
.gsc-video-box.style-2 .video-inner .video-content .title{
   color: <?php echo esc_attr($theme_color) ?>;
}
.gva-video-carousel .video-item-inner .video-link{
   background: <?php echo esc_attr($theme_color) ?>;
}
.gsc-tabs-content .nav_tabs > li a.active{
   background: <?php echo esc_attr($theme_color) ?>;
}
.gsc-tabs-content .nav_tabs > li a.active:after{
   background: <?php echo esc_attr($theme_color) ?>;
}
.gsc-tabs-content .tab-content .tab-pane .tab-content-item ul > li:after{
   color: <?php echo esc_attr($theme_color) ?>;
}
.gsc-team .team-position{
   color: <?php echo esc_attr($theme_color) ?>;
}
.gsc-team.team-horizontal .team-header .social-list a:hover{
   color: <?php echo esc_attr($theme_color) ?> !important;
}
.gsc-team.team-horizontal .team-name:after{
   background: <?php echo esc_attr($theme_color) ?>;
}
.gsc-team.team-vertical .team-body .info{
   background: <?php echo esc_attr($theme_color) ?>;
}
.gsc-work-process .box-content .number-text{
   background: <?php echo esc_attr($theme_color) ?>;
}
.gsc-work-process:hover .box-content .number-text, .gsc-work-process.active .box-content .number-text{
   background: <?php echo esc_attr($theme_color) ?>;
}
.gsc-listings-banner .number-listings{
   background: <?php echo esc_attr($theme_color) ?>;
}
.gva-locations-map .makers .location-item .maker-item-inner .right .location-title:hover{
   color: <?php echo esc_attr($theme_color) ?>;
}
.gva-locations-map .makers .location-item .maker-item-inner:hover .location-title, .gva-locations-map .makers .location-item .maker-item-inner.active .location-title{
   color: <?php echo esc_attr($theme_color) ?>;
}
.gva-locations-map .makers .location-item .maker-item-inner:hover .icon, .gva-locations-map .makers .location-item .maker-item-inner.active .icon{
   color: <?php echo esc_attr($theme_color) ?>;
}
.widget .widget-title:after, .widget .widgettitle:after, .widget .wpb_singleimage_heading:after, .wpb_single_image .widget-title:after, .wpb_single_image .widgettitle:after, .wpb_single_image .wpb_singleimage_heading:after, .wpb_content_element .widget-title:after, .wpb_content_element .widgettitle:after, .wpb_content_element .wpb_singleimage_heading:after{
   background: <?php echo esc_attr($theme_color) ?>;
}
.color-theme .widget-title, .color-theme .widgettitle{
   color: <?php echo esc_attr($theme_color) ?> !important;
}
.wp-sidebar ul li a:hover, .elementor-widget-sidebar ul li a:hover{
   color: <?php echo esc_attr($theme_color) ?>;
}
.wp-sidebar .post-author, .wp-sidebar .post-date, .elementor-widget-sidebar .post-author, .elementor-widget-sidebar .post-date{
   color: <?php echo esc_attr($theme_color) ?>;
}
#wp-footer .footer-widgets .widget_categories a:hover, #wp-footer .footer-widgets .widget_archive a:hover, #wp-footer .footer-widgets .wp-sidebar .widget_nav_menu a:hover, #wp-footer .footer-widgets #wp-footer .widget_nav_menu a:hover, #wp-footer .footer-widgets .elementor-widget-sidebar .widget_nav_menu a:hover, #wp-footer .footer-widgets .widget_pages a:hover, #wp-footer .footer-widgets .widget_meta a:hover{
   color: <?php echo esc_attr($theme_color) ?> !important;
}
#wp-footer .footer-widgets .widget_tag_cloud .tagcloud > a:hover{
   border-color: <?php echo esc_attr($theme_color) ?>;
   color: #fff;
}
.widget_calendar .wp-calendar-table td a{
   color: <?php echo esc_attr($theme_color) ?>;
}
.widget_calendar .wp-calendar-table #today{
   color: <?php echo esc_attr($theme_color) ?>;
}
.widget_calendar .wp-calendar-table #today:after{
   background: <?php echo esc_attr($theme_color) ?>;
}
.widget_tag_cloud .tagcloud > a:hover{
   background: <?php echo esc_attr($theme_color) ?>;
}
.widget_categories ul > li > a:hover, .widget_archive ul > li > a:hover, .wp-sidebar .widget_nav_menu ul > li > a:hover, #wp-footer .widget_nav_menu ul > li > a:hover, .elementor-widget-sidebar .widget_nav_menu ul > li > a:hover, .widget_pages ul > li > a:hover, .widget_meta ul > li > a:hover{
   color: <?php echo esc_attr($theme_color) ?>;
}
.widget_rss ul > li a .post-date, .widget_recent_entries ul > li a .post-date, .gva_widget_recent_entries ul > li a .post-date{
   color: <?php echo esc_attr($theme_color) ?>;
}
.gva_widget_recent_entries ul li .post-content .post-comments .icon{
   color: <?php echo esc_attr($theme_color) ?>;
}
.widget_rss > ul li .rss-date{
   color: <?php echo esc_attr($theme_color) ?>;
}
.opening-time .phone{
   color: <?php echo esc_attr($theme_color) ?>;
}
.helping-text{
   color: <?php echo esc_attr($theme_color) ?>;
}
.support-box .phone a{
   color: <?php echo esc_attr($theme_color) ?>;
}
.download-box a:hover{
   color: <?php echo esc_attr($theme_color) ?>;
}
.post:not(.post-single-content) .entry-content .content-inner .entry-meta .meta-inline > span i{
   color: <?php echo esc_attr($theme_color) ?>;
}
.post:not(.post-single-content) .entry-content .content-inner .entry-meta .meta-inline .entry-date{
   color: <?php echo esc_attr($theme_color) ?>;
}
.post:not(.post-single-content) .tag-links > a:hover{
   background: <?php echo esc_attr($theme_color) ?>;
}
.post.post-style-2 .entry-content .entry-meta .left{
   border: 2px solid <?php echo esc_attr($theme_color) ?>;
}
.post.post-style-2 .entry-content .entry-meta .right i{
   color: <?php echo esc_attr($theme_color) ?>;
}
.post.post-style-2:hover .entry-content .entry-meta .left{
   border-color: <?php echo esc_attr($theme_color) ?>;
}
.post.post-single-content .entry-content .entry-meta .meta-inline > span i{
   color: <?php echo esc_attr($theme_color) ?>;
}
.post.post-single-content .entry-content .entry-meta .meta-inline .entry-date{
   color: <?php echo esc_attr($theme_color) ?>;
}
.post.post-single-content .entry-content .cat-links i{
   color: <?php echo esc_attr($theme_color) ?>;
}
.post.post-single-content .entry-content .cat-links a:hover{
   color: <?php echo esc_attr($theme_color) ?>;
}
.post.post-single-content .entry-content .post-content input[type="submit"]{
   background: <?php echo esc_attr($theme_color) ?>;
}
.post.post-single-content .tag-links > a:hover{
   background: <?php echo esc_attr($theme_color) ?>;
}
.social-networks-post > li:not(.title-share) a:hover{
   background: <?php echo esc_attr($theme_color) ?>;
   border-color: <?php echo esc_attr($theme_color) ?>;
}
.post-navigation a:hover{
   background: <?php echo esc_attr($theme_color) ?>;
}
.tribe-event-list-block .tribe-event-right .content-inner .tribe-events-event-meta .icon{
   color: <?php echo esc_attr($theme_color) ?>;
}
.tribe-events .tribe-events-c-ical__link{
   border-color: <?php echo esc_attr($theme_color) ?>;
   color: <?php echo esc_attr($theme_color) ?>;
}
.tribe-events .tribe-events-c-ical__link:hover, .tribe-events .tribe-events-c-ical__link:active, .tribe-events .tribe-events-c-ical__link:focus{
   background-color: <?php echo esc_attr($theme_color) ?>;
}
.tribe-common .tribe-common-c-btn, .tribe-common a.tribe-common-c-btn{
   background: <?php echo esc_attr($theme_color) ?>;
}
.tribe-common .tribe-common-c-btn:hover, .tribe-common .tribe-common-c-btn:active, .tribe-common .tribe-common-c-btn:focus, .tribe-common a.tribe-common-c-btn:hover, .tribe-common a.tribe-common-c-btn:active, .tribe-common a.tribe-common-c-btn:focus{
   background: <?php echo esc_attr($theme_color) ?>;
   opacity: 0.8;
}
.tribe-events-single .tribe-events-schedule .icon{
   color: <?php echo esc_attr($theme_color) ?>;
}
.tribe-events-single .tribe-events-event-meta .tribe-event-single-detail .tribe-event-single-meta-detail > div .icon{
   color: <?php echo esc_attr($theme_color) ?>;
}
.tribe-events-single .tribe-events-event-meta .tribe-event-meta-bottom .event-single-organizer > .content-inner .meta-item .icon svg{
   fill: <?php echo esc_attr($theme_color) ?>;
}
.tribe-events-single .tribe-events-event-meta .tribe-event-meta-bottom .event-single-venue > .content-inner{
   background: <?php echo esc_attr($theme_color) ?>;
}
.tribe-events-single .tribe-events-event-meta .tribe-event-meta-bottom .event-single-venue > .content-inner:after{
   background: <?php echo esc_attr($theme_color) ?>;
}
.post-type-archive-tribe_events table.tribe-events-calendar tbody td .tribe-events-tooltip .tribe-events-event-body .tribe-event-duration{
   color: <?php echo esc_attr($theme_color) ?>;
}
.post-type-archive-tribe_events table.tribe-events-calendar tbody td:hover{
   border-bottom: 2px solid <?php echo esc_attr($theme_color) ?> !important;
}
.team-block.team-v1 .team-image .socials-team a:hover{
   color: <?php echo esc_attr($theme_color) ?>;
}
.team-block.team-v1 .team-content .socials-team a:hover{
   background: <?php echo esc_attr($theme_color) ?>;
}
.team-block-single .socials-team a:hover{
   background: <?php echo esc_attr($theme_color) ?>;
   border-color: <?php echo esc_attr($theme_color) ?>;
}
.portfolio-v1 .images .link-gallery:hover{
   background: <?php echo esc_attr($theme_color) ?>;
}
.portfolio-v1 .portfolio-content .content-inner .title a:hover{
   color: <?php echo esc_attr($theme_color) ?>;
}
.portfolio-v2 .images .link:hover{
   background: <?php echo esc_attr($theme_color) ?>;
}
.portfolio-v2:hover .portfolio-content, .portfolio-v2:active .portfolio-content, .portfolio-v2:focus .portfolio-content{
   background: <?php echo esc_attr($theme_color) ?>;
}
.pagination .disabled{
   background: <?php echo esc_attr($theme_color) ?>;
}
.pagination .current{
   background: <?php echo esc_attr($theme_color) ?>;
}
.content-page-index .post-masonry-index .post.sticky .entry-content:before{
   color: <?php echo esc_attr($theme_color) ?>;
}
.wpcf7-form select{
   background: <?php echo esc_attr($theme_color) ?>;
}
.newsletter-form input[type="email"]:focus{
   border-bottom-color: <?php echo esc_attr($theme_color) ?>;
}
.newsletter-form .form-action:hover i{
   color: <?php echo esc_attr($theme_color) ?>;
}
#comments .comments-title:after{
   background: <?php echo esc_attr($theme_color) ?>;
}
#comments #add_review_button,
 #comments #submit{
   background: <?php echo esc_attr($theme_color) ?>;
}
#comments #reply-title{
   color: <?php echo esc_attr($theme_color) ?>;
}
#comments ol.comment-list .the-comment .comment-info:after{
   background: <?php echo esc_attr($theme_color) ?>;
}
#comments ol.comment-list .the-comment .comment-info a:hover{
   color: <?php echo esc_attr($theme_color) ?>;
}
#comments ol.comment-list .the-comment .comment-action-wrap a{
   color: <?php echo esc_attr($theme_color) ?>;
}
.pingbacklist > li .the-comment .comment-info:after{
   background: <?php echo esc_attr($theme_color) ?>;
}
.pingbacklist > li .the-comment .comment-info a:hover{
   color: <?php echo esc_attr($theme_color) ?>;
}
.pingbacklist > li .the-comment .comment-action-wrap a{
   color: <?php echo esc_attr($theme_color) ?>;
}
.cld-like-dislike-wrap .cld-like-wrap{
   color: <?php echo esc_attr($theme_color) ?>;
}
.cld-like-dislike-wrap .cld-like-wrap a{
   color: <?php echo esc_attr($theme_color) ?>;
}
.owl-carousel .owl-nav > div, .flex-control-nav .owl-nav > div, .ctf-tweets .owl-nav > div{
   background: <?php echo esc_attr($theme_color) ?>;
}
ul.nav-tabs > li > a:hover, ul.nav-tabs > li > a:focus, ul.nav-tabs > li > a:active{
   color: <?php echo esc_attr($theme_color) ?>;
}
ul.nav-tabs > li.active > a{
   background: <?php echo esc_attr($theme_color) ?>;
}
.select2-container .select2-dropdown ul.select2-results__options li.select2-results__option--highlighted{
   color: <?php echo esc_attr($theme_color) ?>;
}
.select2-container .select2-dropdown ul.select2-results__options li[aria-selected="true"]{
   color: <?php echo esc_attr($theme_color) ?>;
}
.select2-container .select2-selection .select2-selection__rendered .select2-selection__clear{
   background: <?php echo esc_attr($theme_color) ?>;
}
.select2-selection.select2-selection--multiple .select2-selection__rendered li.select2-selection__choice .select2-selection__choice__remove{
   background: <?php echo esc_attr($theme_color) ?>;
}
#ui-datepicker-div button{
   background: <?php echo esc_attr($theme_color) ?>;
}
#ui-datepicker-div .ui-widget-header{
   background: <?php echo esc_attr($theme_color) ?>;
}

.woocommerce-tab-product-info .submit{
   background: <?php echo esc_attr($theme_color) ?>;
}
.minibasket.light i{
   color: <?php echo esc_attr($theme_color) ?>;
}
table.variations a.reset_variations{
   color: <?php echo esc_attr($theme_color) ?> !important;
}
.single-product .social-networks > li a:hover{
   color: <?php echo esc_attr($theme_color) ?>;
}
.single-product .image_frame .woocommerce-product-gallery__trigger:hover{
   background: <?php echo esc_attr($theme_color) ?>;
}
.single-product .image_frame .onsale{
   background: <?php echo esc_attr($theme_color) ?>;
}
.single-product ol.flex-control-nav.flex-control-thumbs .owl-item img.flex-active{
   border: 1px solid <?php echo esc_attr($theme_color) ?>;
}
.single-product .product-single-main.product-type-grouped table.group_table tr td.label a:hover, .single-product .product-single-main.product-type-grouped table.group_table tr td label a:hover{
   color: <?php echo esc_attr($theme_color) ?>;
}
.single-product .entry-summary .woocommerce-product-rating .woocommerce-review-link:hover{
   color: <?php echo esc_attr($theme_color) ?>;
}
.single-product .entry-summary .price{
   color: <?php echo esc_attr($theme_color) ?>;
}
.single-product .product-single-inner .cart .button:hover, .single-product .product-single-inner .add-cart .button:hover{
   background: <?php echo esc_attr($theme_color) ?>;
}
.single-product .product-single-inner .yith-wcwl-add-to-wishlist a{
   background: <?php echo esc_attr($theme_color) ?>;
}
.single-product .product-single-inner .yith-wcwl-add-to-wishlist a:hover{
   background: <?php echo esc_attr($theme_color) ?>;
}
.single-product .product-single-inner a.compare{
   background: <?php echo esc_attr($theme_color) ?>;
}
.single-product .product-single-inner a.compare:hover{
   background: <?php echo esc_attr($theme_color) ?>;
}
.single-product .product-single-inner form.cart .table-product-group td.label a:hover{
   color: <?php echo esc_attr($theme_color) ?>;
}
.single-product .product-single-inner form.cart .add-cart button{
   background: <?php echo esc_attr($theme_color) ?>;
}
.single-product .product-single-inner form.cart .add-cart button:hover{
   background: <?php echo esc_attr($theme_color) ?>;
}
.single-product .product_meta > span a:hover{
   color: <?php echo esc_attr($theme_color) ?>;
}
.woocommerce-account .woocommerce-MyAccount-navigation ul > li.is-active a{
   color: <?php echo esc_attr($theme_color) ?>;
}
.woocommerce #breadcrumb a:hover{
   color: <?php echo esc_attr($theme_color) ?>;
}
.woocommerce-page .content-page-inner input.button:hover, .woocommerce-page .content-page-inner a.button:hover{
   background: <?php echo esc_attr($theme_color) ?>;
}
.woocommerce-cart-form__contents .woocommerce-cart-form__cart-item td.product-remove a.remove{
   background: <?php echo esc_attr($theme_color) ?>;
}
.shop-loop-actions .quickview a:hover, .shop-loop-actions .yith-wcwl-add-to-wishlist a:hover, .shop-loop-actions .yith-compare a:hover, .shop-loop-actions .add-to-cart a:hover{
   background: <?php echo esc_attr($theme_color) ?>;
}
.shop-loop-price .price{
   color: <?php echo esc_attr($theme_color) ?>;
}
.gva-countdown .countdown-times > div.day{
   color: <?php echo esc_attr($theme_color) ?>;
}
.product_list_widget.cart_list .widget-product .name a:hover{
   color: <?php echo esc_attr($theme_color) ?> !important;
}
.product_list_widget.cart_list .widget-product .remove{
   background: <?php echo esc_attr($theme_color) ?>;
}
.woo-display-mode > a:hover, .woo-display-mode > a:active, .woo-display-mode > a:focus, .woo-display-mode > a.active{
   background: <?php echo esc_attr($theme_color) ?>;
}
.filter-sidebar .filter-sidebar-inner.layout-offcavas .filter-close{
   background: <?php echo esc_attr($theme_color) ?>;
}
.woocommerce .button[type*="submit"]:hover{
   background: <?php echo esc_attr($theme_color) ?>;
}
.widget.widget_layered_nav ul > li a:hover{
   color: <?php echo esc_attr($theme_color) ?>;
}
.widget.widget_product_categories li.current-cat > a{
   color: <?php echo esc_attr($theme_color) ?> !important;
}
.widget.widget_product_categories ul.product-categories > li.has-sub .cat-caret:hover{
   color: <?php echo esc_attr($theme_color) ?>;
}
.widget.widget_product_categories ul.product-categories > li ul a:hover{
   color: <?php echo esc_attr($theme_color) ?>;
}


<?php } //End Color Theme ?> 

<?php

      $styles = ob_get_clean();
      
      $styles = preg_replace( '!/\*[^*]*\*+([^/][^*]*\*+)*/!', '', $styles );
      
      $styles = str_replace( array( "\r\n", "\r", "\n", "\t", '  ', '   ', '    ' ), '', $styles );

      if($styles){
         wp_enqueue_style( 'kitecx-custom-style-color', KITECX_THEME_URL . '/css/custom_script.css');
         wp_add_inline_style( 'kitecx-custom-style-color', $styles );
      }

   }
}

add_action( 'wp_enqueue_scripts', 'kitecx_custom_color_theme', 99999 );