<?php
/**
	* $Desc
	*
	* @author     Gaviasthemes Team     
	* @copyright  Copyright (C) 2021 gaviasthemes. All Rights Reserved.
	* @license    GNU/GPL v2 or later http://www.gnu.org/licenses/gpl-2.0.html
	* 
*/

define('KITECX_THEME_DIR', get_template_directory());
define('KITECX_THEME_URL', get_template_directory_uri());

/*
	* Include list of files from Gavias Framework.
*/
require_once(KITECX_THEME_DIR . '/includes/theme-functions.php'); 
require_once(KITECX_THEME_DIR . '/includes/template.php'); 
require_once(KITECX_THEME_DIR . '/includes/theme-hook.php'); 
require_once(KITECX_THEME_DIR . '/includes/theme-layout.php'); 
require_once(KITECX_THEME_DIR . '/includes/comment.php'); 
require_once(KITECX_THEME_DIR . '/includes/metaboxes.php'); 
require_once(KITECX_THEME_DIR . '/includes/menu/megamenu.php'); 
require_once(KITECX_THEME_DIR . '/includes/elementor/hooks.php');
require_once(KITECX_THEME_DIR . '/includes/customize/custom-typo.php'); 
require_once(KITECX_THEME_DIR . '/includes/customize/custom-color.php'); 

//Load Woocommerce plugin
if(class_exists('WooCommerce')){
	add_theme_support('woocommerce');
	require_once(KITECX_THEME_DIR . '/includes/woocommerce/functions.php'); 
	require_once(KITECX_THEME_DIR . '/includes/woocommerce/hooks.php'); 
}

// Load Redux - Theme options framework
if(class_exists('Redux')){
	require(KITECX_THEME_DIR . '/includes/options/init.php');
	require_once(KITECX_THEME_DIR . '/includes/options/opts-general.php'); 
	require_once(KITECX_THEME_DIR . '/includes/options/opts-header.php'); 
	require_once(KITECX_THEME_DIR . '/includes/options/opts-footer.php'); 
	require_once(KITECX_THEME_DIR . '/includes/options/opts-breadcrumb.php'); 
	require_once(KITECX_THEME_DIR . '/includes/options/opts-styling.php'); 
	require_once(KITECX_THEME_DIR . '/includes/options/opts-typography.php'); 
	require_once(KITECX_THEME_DIR . '/includes/options/opts-blog.php'); 
	require_once(KITECX_THEME_DIR . '/includes/options/opts-page.php'); 
	require_once(KITECX_THEME_DIR . '/includes/options/opts-portfolio.php'); 
	require_once(KITECX_THEME_DIR . '/includes/options/opts-event.php'); 
	 if(class_exists('WooCommerce')){
		require_once(KITECX_THEME_DIR . '/includes/options/opts-woo.php'); 
	 }
} 

// TGM plugin activation
if (is_admin()) {
	require_once(KITECX_THEME_DIR . '/includes/tgmpa/class-tgm-plugin-activation.php');
	require(KITECX_THEME_DIR . '/includes/tgmpa/config.php');
}
load_theme_textdomain('kitecx', get_template_directory() . '/languages');

//-------- Register sidebar default in theme -----------
//------------------------------------------------------
function kitecx_widgets_init() {
	register_sidebar(array(
		'name' 				=> esc_html__('Default Sidebar', 'kitecx'),
		'id' 					=> 'default_sidebar',
		'description' 		=> esc_html__('Appears in the Default Sidebar section of the site.', 'kitecx'),
		'before_widget' 	=> '<aside id="%1$s" class="widget clearfix %2$s">',
		'after_widget' 	=> '</aside>',
		'before_title' 	=> '<h3 class="widget-title"><span>',
		'after_title' 		=> '</span></h3>',
	));

	if(class_exists('WooCommerce')){
		register_sidebar( array(
			'name' 				=> esc_html__('WooCommerce Sidebar', 'kitecx'),
			'id' 					=> 'woocommerce_sidebar',
			'description' 		=> esc_html__('Appears in the Plugin WooCommerce section of the site.', 'kitecx'),
			'before_widget' 	=> '<aside id="%1$s" class="widget clearfix %2$s">',
			'after_widget'	 	=> '</aside>',
			'before_title' 	=> '<h3 class="widget-title"><span>',
			'after_title' 		=> '</span></h3>',
		));
		register_sidebar(array(
			'name' 				=> esc_html__('WooCommerce Single', 'kitecx'),
			'id' 					=> 'woocommerce_single_summary',
			'description' 		=> esc_html__('Appears in the WooCommerce Single Page like social, description text ...', 'kitecx'),
			'before_widget' 	=> '<aside id="%1$s" class="widget clearfix %2$s">',
			'after_widget' 	=> '</aside>',
			'before_title' 	=> '<h3 class="widget-title"><span>',
			'after_title' 		=> '</span></h3>',
		));
	}
	register_sidebar(array(
		'name' 				=> esc_html__('After Offcanvas Mobile', 'kitecx'),
		'id' 					=> 'offcanvas_sidebar_mobile',
		'description' 		=> esc_html__('Appears in the Offcanvas section of the site.', 'kitecx'),
		'before_widget' 	=> '<aside id="%1$s" class="widget clearfix %2$s">',
		'after_widget' 	=> '</aside>',
		'before_title' 	=> '<h3 class="widget-title"><span>',
		'after_title' 		=> '</span></h3>',
	));
	register_sidebar(array(
		'name' 				=> esc_html__('Blog Sidebar', 'kitecx'),
		'id' 					=> 'blog_sidebar',
		'description' 		=> esc_html__('Appears in the Blog sidebar section of the site.', 'kitecx'),
		'before_widget' 	=> '<aside id="%1$s" class="widget clearfix %2$s">',
		'after_widget' 	=> '</aside>',
		'before_title' 	=> '<h3 class="widget-title"><span>',
		'after_title' 		=> '</span></h3>',
	));
	register_sidebar(array(
		'name' 					=> esc_html__('Page Sidebar', 'kitecx'),
		'id' 						=> 'other_sidebar',
		'description' 			=> esc_html__('Appears in the Page Sidebar section of the site.', 'kitecx'),
		'before_widget' 		=> '<aside id="%1$s" class="widget clearfix %2$s">',
		'after_widget' 		=> '</aside>',
		'before_title' 		=> '<h3 class="widget-title"><span>',
		'after_title' 			=> '</span></h3>',
	));
	register_sidebar(array(
		'name' 					=> esc_html__('Portfolio Sidebar', 'kitecx'),
		'id' 						=> 'porfolio_sidebar',
		'description' 			=> esc_html__('Appears in the Portfolio Page Sidebar section of the site.', 'kitecx'),
		'before_widget' 		=> '<aside id="%1$s" class="widget clearfix %2$s">',
		'after_widget' 		=> '</aside>',
		'before_title' 		=> '<h3 class="widget-title"><span>',
		'after_title' 			=> '</span></h3>',
	));
	register_sidebar(array(
		'name' 				=> esc_html__('Footer first', 'kitecx'),
		'id' 					=> 'footer-sidebar-1',
		'description' 		=> esc_html__('Appears in the Footer first section of the site.', 'kitecx'),
		'before_widget' 	=> '<aside id="%1$s" class="widget clearfix %2$s">',
		'after_widget' 	=> '</aside>',
		'before_title' 	=> '<h3 class="widget-title"><span>',
		'after_title' 		=> '</span></h3>',
	));
	register_sidebar(array(
		'name' 				=> esc_html__('Footer second', 'kitecx'),
		'id' 					=> 'footer-sidebar-2',
		'description' 		=> esc_html__('Appears in the Footer second section of the site.', 'kitecx'),
		'before_widget' 	=> '<aside id="%1$s" class="widget clearfix %2$s">',
		'after_widget' 	=> '</aside>',
		'before_title' 	=> '<h3 class="widget-title"><span>',
		'after_title' 		=> '</span></h3>',
	));
	register_sidebar(array(
		'name' 				=> esc_html__('Footer third', 'kitecx'),
		'id' 					=> 'footer-sidebar-3',
		'description' 		=> esc_html__('Appears in the Footer third section of the site.', 'kitecx'),
		'before_widget' 	=> '<aside id="%1$s" class="widget clearfix %2$s">',
		'after_widget' 	=> '</aside>',
		'before_title' 	=> '<h3 class="widget-title"><span>',
		'after_title' 		=> '</span></h3>',
	));
	register_sidebar(array(
		'name' 				=> esc_html__('Footer four', 'kitecx'),
		'id' 					=> 'footer-sidebar-4',
		'description' 		=> esc_html__('Appears in the Footer four section of the site.', 'kitecx'),
		'before_widget' 	=> '<aside id="%1$s" class="widget clearfix %2$s">',
		'after_widget' 	=> '</aside>',
		'before_title' 	=> '<h3 class="widget-title"><span>',
		'after_title' 	=> '</span></h3>',
	));
}
add_action('widgets_init', 'kitecx_widgets_init');


if ( ! function_exists('kitecx_fonts_url') ) :
/**
 *
 * @return string Google fonts URL for the theme.
 */
function kitecx_fonts_url() { 
	$fonts_url = '';
	$fonts     = array();
	$subsets   = '';
	$protocol = is_ssl() ? 'https' : 'http';
	/*
		* Translators: If there are characters in your language that are not supported
		* by Noto Sans, translate this to 'off'. Do not translate into your own language.
	*/
	if('off' !== _x('on', 'Roboto font: on or off', 'kitecx')){
		$fonts[] = 'Roboto:wght@400;500;700;800';
	}
	if($fonts){
		$fonts_url = add_query_arg( array(
			'family' => (implode('&family=', $fonts)),
			'display' => 'swap',
		),  $protocol.'://fonts.googleapis.com/css2');
	}

	return $fonts_url;
}

endif;

function kitecx_custom_styles() {
	$custom_css = get_option('kitecx_theme_custom_styles');
	if($custom_css){
		wp_enqueue_style(
			'kitecx-custom-style',
			KITECX_THEME_URL . '/css/custom_script.css'
		);
		wp_add_inline_style('kitecx-custom-style', $custom_css);
	}
}
add_action('wp_enqueue_scripts', 'kitecx_custom_styles', 9999);

function kitecx_init_scripts(){
	global $post;
	$protocol = is_ssl() ? 'https' : 'http';
	if ( is_singular() && comments_open() && get_option('thread_comments') ){
		wp_enqueue_script('comment-reply');
	}

	$skin = kitecx_get_option('skin_color', '');
	$skin = !empty($skin) ? 'skins/' . $skin . '/' : ''; 
	$theme = wp_get_theme('kitecx');
	$theme_version = $theme['Version'];

	wp_enqueue_style('kitecx-fonts', kitecx_fonts_url(), array(), null );
	wp_enqueue_script('bootstrap', KITECX_THEME_URL . '/js/bootstrap.min.js', array('jquery') );
	wp_enqueue_script('perfect-scrollbar', KITECX_THEME_URL . '/js/perfect-scrollbar.jquery.min.js');
	wp_enqueue_script('jquery-magnific-popup', KITECX_THEME_URL . '/js/magnific/jquery.magnific-popup.min.js');
	wp_enqueue_script('jquery-cookie', KITECX_THEME_URL . '/js/jquery.cookie.js', array('jquery'));
	wp_enqueue_script('owl-carousel', KITECX_THEME_URL . '/js/owl-carousel/owl.carousel.min.js');
	wp_enqueue_script('jquery-appear', KITECX_THEME_URL . '/js/jquery.appear.js');
	wp_enqueue_script('kitecx-main', KITECX_THEME_URL . '/js/main.js', array('imagesloaded', 'jquery-masonry'));
  
	wp_enqueue_style('dashicons');
	wp_enqueue_style('owl-carousel', KITECX_THEME_URL .'/js/owl-carousel/assets/owl.carousel.css');
	wp_enqueue_style('magnific', KITECX_THEME_URL .'/js/magnific/magnific-popup.css');
	wp_enqueue_style('fontawesome', KITECX_THEME_URL . '/css/fontawesome/css/all.css');
	wp_enqueue_style('line-awesome', KITECX_THEME_URL . '/css/line-awesome/css/line-awesome.min.css');

	wp_enqueue_style('kitecx-style', KITECX_THEME_URL . '/style.css');
	wp_enqueue_style('bootstrap', KITECX_THEME_URL . '/css/' . $skin . 'bootstrap.css', array(), $theme_version , 'all'); 
	wp_enqueue_style('kitecx-template', KITECX_THEME_URL . '/css/' . $skin . 'template.css', array(), $theme_version , 'all');
	
	//Woocommerce
	if(class_exists('WooCommerce')){
		wp_enqueue_script('kitecx-woocommerce', KITECX_THEME_URL . '/js/woocommerce.js');
		wp_dequeue_script('wc-add-to-cart');
		wp_register_script('wc-add-to-cart', KITECX_THEME_URL . '/js/add-to-cart.js' , array('jquery'));
		wp_enqueue_script('wc-add-to-cart');
		wp_enqueue_style('kitecx-woocoomerce', KITECX_THEME_URL . '/css/' . $skin . 'woocommerce.css', array(), $theme_version , 'all'); 
	}
}
add_action('wp_enqueue_scripts', 'kitecx_init_scripts', 9);

