<?php

if (!defined('ABSPATH')) {
	 exit; // Exit if accessed directly.
}

use Elementor\Controls_Manager;
use Elementor\Utils;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;
use Elementor\Repeater;

class GVAElement_Testimonial_Single extends GVAElement_Base{

	/**
	  * Get widget name.
	  *
	  * Retrieve testimonial widget name.
	  *
	  * @since  1.0.0
	  * @access public
	  *
	  * @return string Widget name.
	*/
	public function get_name() {
		return 'gva-testimonials-single';
	}

	/**
	  * Get widget title.
	  *
	  * Retrieve testimonial widget title.
	  *
	  * @since  1.0.0
	  * @access public
	  *
	  * @return string Widget title.
	*/
	public function get_title() {
		return __('GVA Testimonials Single', 'kitecx-themer');
	}

	/**
	  * Get widget icon.
	  *
	  * Retrieve testimonial widget icon.
	  *
	  * @since  1.0.0
	  * @access public
	  *
	  * @return string Widget icon.
	*/
	public function get_icon() {
		return 'eicon-posts-carousel';
	}

	public function get_keywords() {
		return [ 'testimonial', 'content', 'carousel' ];
	}

	public function get_script_depends() {
		return [
			'jquery.owl.carousel',
			'gavias.elements',
		];
	}

	public function get_style_depends() {
		return array('owl-carousel-css');
	}

	/**
	  * Register testimonial widget controls.
	  *
	  * Adds different input fields to allow the user to change and customize the widget settings.
	  *
	  * @since  1.0.0
	  * @access protected
	*/
	protected function register_controls() {
		$this->start_controls_section(
			'section_testimonial',
			[
				'label' => __('Testimonials', 'kitecx-themer'),
			]
		);
		$this->add_control(
			'style',
			array(
				 'label'   => esc_html__( 'Style', 'kitecx-themer' ),
				 'type'    => Controls_Manager::SELECT,
				 'default' => 'style-1',
				 'options' => [
					'style-1' => esc_html__('Style I', 'kitecx-themer'),
				]
			)
		);

		$repeater = new Repeater();
		$repeater->add_control(
			'testimonial_content',
			[
				'label'       => __('Content', 'kitecx-themer'),
				'type'        => Controls_Manager::TEXTAREA,
				'default'     => 'This is due to their excellent service competitive pricing and customer support. It’s throughly refresing to get such a personal touch. There are many variations of passages of available, but the majority have suffered alteration in some form by injected humour.',
				'label_block' => true,
				'rows'        => '10',
			]
		);
		$repeater->add_control(
		  'testimonial_image',
			[
				'label'      => __('Testimonial Image', 'kitecx-themer'),
				'default'    => [
					'url' => GAVIAS_KITECX_PLUGIN_URL . 'elementor/assets/images/testimonial.png',
				],
				'type'       => Controls_Manager::MEDIA,
			]
		);
		$repeater->add_control(
			'testimonial_name',
			[
				'label'   => __('Name', 'kitecx-themer'),
				'default' => 'John Doe',
				'type'    => Controls_Manager::TEXT,
			]
		);
	  	$repeater->add_control(
		  'testimonial_job',
			[
				'label'   => __('Job', 'kitecx-themer'),
				'default' => esc_html__('Director', 'kitecx-themer'),
				'type'    => Controls_Manager::TEXT
			]
	  	);

	  	$this->add_control(
			'testimonials',
			[
				'label'       => __('Testimonials Content Item', 'kitecx-themer'),
				'type'        => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ testimonial_name }}}',
				'default'     => array(
					array(
						'testimonial_name'     => esc_html__( 'Christine Eve', 'kitecx-themer' ),
					),
					array(
						'testimonial_name'     => esc_html__( 'Kevin Smith', 'kitecx-themer' ),
					),
					array(
						'testimonial_name'     => esc_html__( 'Jessica Brown', 'kitecx-themer' ),
					),
				 ),
			]
	  	);

		$this->end_controls_section();

		$this->add_control_carousel( 'always_single',
			array(
				'style' => ['style-1', 'style-2']
			)
		);

	 	 // Style.
	  	$this->start_controls_section(
			'section_style_content',
			[
				 'label' => __('Content', 'kitecx-themer'),
				 'tab'   => Controls_Manager::TAB_STYLE,
			]
	  	);
	  	$this->add_control(
			'content_content_color',
			[
				 'label'     => __('Text Color', 'kitecx-themer'),
				 'type'      => Controls_Manager::COLOR,
				 'default'   => '',
				 'selectors' => [
					  '{{WRAPPER}} .gva-testimonial-single .testimonial-quote' => 'color: {{VALUE}};',
				 ],
			]
	  	);
		$this->add_group_control(
				Group_Control_Typography::get_type(),
				[
					'name'     => 'content_typography',
					'selector' => '{{WRAPPER}} .gva-testimonial-single .testimonial-quote',
				]
		);
		$this->end_controls_section();

		// Name Styling
		$this->start_controls_section(
			'section_style_name',
			[
				'label' => __('Name', 'kitecx-themer'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'name_text_color',
			[
				'label'     => __('Text Color', 'kitecx-themer'),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .gva-testimonial-single .testimonial-item .testimonial-content .testimonial-info .testimonial-meta .testimonial-name' => 'color: {{VALUE}};',
				],
			]
		);
	  	$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'name_typography',
				'selector' => '{{WRAPPER}} .gva-testimonial-single .testimonial-item .testimonial-content .testimonial-info .testimonial-meta .testimonial-name',
			]
	  	);
		$this->end_controls_section();

		// Job Styling
		$this->start_controls_section(
			'section_style_job',
			[
				'label' => __('Job', 'kitecx-themer'),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);
		$this->add_control(
			'job_text_color',
			[
				'label'     => __('Text Color', 'kitecx-themer'),
				'type'      => Controls_Manager::COLOR,
				'default'   => '',
				'selectors' => [
					'{{WRAPPER}} .gva-testimonial-single .testimonial-item .testimonial-content .testimonial-info .testimonial-meta .testimonial-job' => 'color: {{VALUE}};',
				],
			]
		);
	  	$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'job_typography',
				'selector' => '{{WRAPPER}} .gva-testimonial-single .testimonial-item .testimonial-content .testimonial-info .testimonial-meta .testimonial-job',
			]
	  	);
		$this->end_controls_section();

	 }

	 /**
	  * Render testimonial widget output on the frontend.
	  *
	  * Written in PHP and used to generate the final HTML.
	  *
	  * @since  1.0.0
	  * @access protected
	  */
	 protected function render() {
		$settings = $this->get_settings_for_display();
		printf( '<div class="gva-element-%s gva-element">', $this->get_name() );
		if(isset($settings['style']) && $settings['style']){
			include $this->get_template('testimonials-single/' . $settings['style'] . '.php');
		}
		print '</div>';
	 }

}
$widgets_manager->register(new GVAElement_Testimonial_Single());
