<?php

if ( ! defined( 'ABSPATH' ) ) {
   exit; // Exit if accessed directly.
}
use Elementor\Controls_Manager;
use Elementor\Scheme_Color;
use Elementor\Group_Control_Typography;
use Elementor\Scheme_Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Image_Size;
/**
 * Elementor heading widget.
 *
 * Elementor widget that displays an eye-catching headlines.
 *
 * @since 1.0.0
 */
class GVAElement_Compare_images extends GVAElement_Base {

   /**
    * Get widget name.
    *
    * Retrieve heading widget name.
    *
    * @since 1.0.0
    * @access public
    *
    * @return string Widget name.
    */
   public function get_name() {
      return 'gva-compare-images';
   }

   /**
    * Get widget title.
    *
    * Retrieve heading widget title.
    *
    * @since 1.0.0
    * @access public
    *
    * @return string Widget title.
    */
   public function get_title() {
      return __( 'GVA Compare Images', 'kitecx-themer' );
   }

   public function get_script_depends() {
      return [
         'event-move',
         'twentytwenty',
         'gavias.elements',
      ];
   }

   /**
    * Get widget icon.
    *
    * Retrieve heading widget icon.
    *
    * @since 1.0.0
    * @access public
    *
    * @return string Widget icon.
    */
   public function get_icon() {
      return 'eicon-featured-image';
   }

   /**
    * Get widget keywords.
    *
    * Retrieve the list of keywords the widget belongs to.
    *
    * @since 2.1.0
    * @access public
    *
    * @return array Widget keywords.
    */
   public function get_keywords() {
      return [ 'image', 'content', 'compare' ];
   }

   /**
    * Register heading widget controls.
    *
    * Adds different input fields to allow the user to change and customize the widget settings.
    *
    * @since 1.0.0
    * @access protected
    */
   protected function register_controls() {
      $this->start_controls_section(
         'section_title',
         [
            'label' => __( 'Content', 'kitecx-themer' ),
         ]
      );

      $this->add_control(
      'title',
        [
          'label' => __( 'Title', 'kitecx-themer' ),
          'type' => Controls_Manager::TEXT,
          'placeholder' => __( 'Enter your title', 'kitecx-themer' ),
        ]
      );
      $this->add_control(
         'style',
         [
            'label' => __( 'Style', 'kitecx-themer' ),
            'type' => Controls_Manager::SELECT,
            'options' => [
               'style-1' => esc_html__('Style I', 'kitecx-themer'),
            ],
            'default' => 'style-1',
         ]
      );

      $this->add_control(
         'image',
         [
            'label' => __( 'Choose Image', 'kitecx-themer' ),
            'type' => Controls_Manager::MEDIA,
            'label_block' => true,
            'default' => [
               'url' => GAVIAS_KITECX_PLUGIN_URL . 'elementor/assets/images/image-compare-1.jpg',
            ],
         ]
      );

      $this->add_control(
         'image_second',
         [
            'label' => __( 'Choose Image Second', 'kitecx-themer' ),
            'type' => Controls_Manager::MEDIA,
            'label_block' => true,
            'default' => [
               'url' => GAVIAS_KITECX_PLUGIN_URL . 'elementor/assets/images/image-compare-2.jpg',
            ],
         ]
      );
   
      $this->end_controls_section();

   }

   /**
    * Render heading widget output on the frontend.
    *
    * Written in PHP and used to generate the final HTML.
    *
    * @since 1.0.0
    * @access protected
    */
   protected function render() {
      
      printf( '<div class="gva-element-%s gva-element">', $this->get_name() );
         include $this->get_template('compare-images.php');
      print '</div>';
   }

}

 $widgets_manager->register(new GVAElement_Compare_images());
