<?php

  // Namespace
  namespace BMI\Plugin\Dashboard;

  // Exit on direct access
  if (!defined('ABSPATH')) exit;

  // Tooltips
  $ctl = __("Your account on Wordpress.org (where you open a new support thread) is different to the one you login to your WordPress dashboard (where you are now). If you don’t have a WordPress.org account yet, please sign up at the top right on the Support Forum page, and then scroll down on that page . It only takes a minute :) Thank you!", 'backup-backup');

?>

<div class="bmi-modal" id="backup-success-modal">

  <div class="bmi-modal-wrapper no-hpad" style="max-width: 900px; max-width: min(900px, 80vw)">
    <div class="bmi-modal-content">

      <div class="mms mm60 f30 bold center black"><?php _e('Backup successful!', 'backup-backup') ?></div>

      <div class="center mm60 mbl mtl">
        <img src="<?php echo $this->get_asset('images', 'happy-smile.png'); ?>" alt="happy-img">
      </div>

      <div id="accessible-at-section" class="mm60">
        <div class="mms mbl">
          <div class="f18 mbll">
            <?php _e('Your backup is now accessible at:', 'backup-backup') ?>
          </div>
          <div class="cf success-copy-input">
            <input type="text" id="text-input-copy" readonly class="left f18">
            <a href="#" class="btn inline btn-with-img btn-img-low-pad btn-pad left bmi-copper" data-copy="text-input-copy">
              <div class="text">
                <img src="<?php echo $this->get_asset('images', 'copy-icon.png'); ?>" alt="copy-img">
                <div class="f18 semibold"><?php _e('Copy', 'backup-backup') ?></div>
              </div>
            </a>
          </div>
        </div>

        <div class="mms f18 mtl lh30">
          <?php $st1l = __('To migrate your site, just copy above link, install %a1our plugin%a2 on the target site, go to the', 'backup-backup'); ?>
          <?php echo str_replace('%a2', '</a>', str_replace('%a1', '<a class="hoverable secondary" href="https://wordpress.org/plugins/backup-backup" target="_blank">', $st1l)); ?>
          "<a href="#" class="hoverable secondary go-to-marbs"><?php _e('Manage & Restore Backups', 'backup-backup') ?></a>"
          <?php _e('- tab, and paste the link there.', 'backup-backup') ?>
        </div>
      </div>

      <div class="bmi-ask-for-review">
        <div class="cf mm60">
          <div class="left bmi-positive-wrapper">
            <img src="<?php echo $this->get_asset('images', 'big-thumb-up.svg'); ?>" alt="positive-thumb-up" class="bmi-positive-thumb">
          </div>
          <div class="left bmi-thumb-info">
            <div class="f16 lh30 mm30 mtll mbll">
              <?php _e("Like how easy it was? Then <b>PLEASE</b> give us a nice rating so that others discover out plugin & benefit from it too. Thank you!!", 'backup-backup'); ?>
            </div>
            <div class="cf lh60 mm30">
              <div class="left">
                <a href="https://wordpress.org/support/plugin/backup-backup/reviews/#new-post" target="_blank" class="btn inline btn-pad mm30">
                  <div class="text">
                    <div class="f14 semibold"><?php _e('Sounds fair, let me give a rating', 'backup-backup'); ?></div>
                  </div>
                </a>
              </div>
              <div class="right relative">
                <a href="#!" class="nodec secondary semibold">
                  <span class="tooltip hoverable info-cursor f14" tooltip="<?php echo $ctl; ?>">
                    <?php _e("Trouble logging in?", 'backup-backup'); ?>
                    <span class="bmi-info-icon"></span>
                  </span>
                </a>
              </div>
            </div>
          </div>
        </div>
      </div>

      <div class="f18 mtl mbl mms lh14 mm60">
        <?php _e('You can manage the backup on the', 'backup-backup') ?>
        "<a href="#" class="hoverable secondary go-to-marbs"><?php _e('Manage & Restore Backups', 'backup-backup') ?></a>"
        <?php _e('- tab.', 'backup-backup') ?>
      </div>

      <div class="mms mtl flex-here lh50 mm60">
        <div class="f18 align-left">
          <a href="#" class="nlink hoverable" id="download-backup-url" download><?php _e('Download backup', 'backup-backup') ?></a>
        </div>

        <div class="center">
          <a href="#" class="btn inline btn-pad bmi-modal-closer grey-btn nplr" data-close="backup-success-modal">
            <div class="text">
              <div class="f18 semibold"><?php _e('Close window', 'backup-backup') ?></div>
            </div>
          </a>
        </div>

        <div class="f18 inline align-right">
          <a href="#" class="nlink hoverable download-backup-log-url" download="backup_logs.txt">
            <?php _e('Download logs', 'backup-backup') ?>
          </a>
        </div>
      </div>

    </div>
  </div>

</div>
