<?php

  // Namespace
  namespace BMI\Plugin\Dashboard;

  // Exit on direct access
  if (!defined('ABSPATH')) exit;

  $urlparts = parse_url(home_url());
  $domain = $urlparts['host'];

?>

<div class="mm mt mb">

  <div class="lh30">
    <div class="f20 semibold"><?php _e("File name", 'backup-backup'); ?></div>
    <div class="f20"><?php _e("Your backup(s) will be given the following file name(s)", 'backup-backup'); ?></div>
  </div>

  <div class="center mtl f18">
    <div class="">
      <input type="text" id="backup_filename" class="bmi-text-input" value="<?php echo sanitize_text_field(bmi_get_config('BACKUP:NAME')); ?>">
      <span class="oll mrr">.zip </span><a href="#" id="show-format-tip" class="nodec secondary hoverable"><?php _e("Huh? Explain this please", 'backup-backup'); ?></a>
    </div>
  </div>

</div>

<div class="mm lh30 f16 bg-second mtl mbl" id="format-tip-wrp" style="display: none;">

  <div class="lh30 f18">
    <?php _e("We’re giving you maximum flexibility to automatically name your backup files in the way you want. Simply use below keys:", 'backup-backup'); ?>
  </div>
  <div class="mm mtl">
    <div class="format-entry"><b>%Y</b> = <?php _e("A full numeric representation of a year, 4 digits", 'backup-backup'); ?></div>
    <div class="format-entry"><b>%M</b> = <?php _e("A short textual representation of a month, three letters", 'backup-backup'); ?></div>
    <div class="format-entry"><b>%D</b> = <?php _e("A textual representation of a day, three letters", 'backup-backup'); ?></div>
    <div class="format-entry"><b>%d</b> = <?php _e("Day of the month, 2 digits with leading zeros", 'backup-backup'); ?></div>
    <div class="format-entry"><b>%j</b> = <?php _e("Day of the month without leading zeros", 'backup-backup'); ?></div>
    <div class="format-entry"><b>%m</b> = <?php _e("Numeric representation of a month, with leading zeros", 'backup-backup'); ?></div>
    <div class="format-entry"><b>%n</b> = <?php _e("Numeric representation of a month, without leading zeros", 'backup-backup'); ?></div>
    <div class="format-entry"><b>%Y</b> = <?php _e("A full numeric representation of a year, 4 digits", 'backup-backup'); ?></div>
    <div class="format-entry"><b>%y</b> = <?php _e("A two digit representation of a year", 'backup-backup'); ?></div>
    <div class="format-entry"><b>%a</b> = <?php _e("Lowercase Ante meridiem and Post meridiem", 'backup-backup'); ?></div>
    <div class="format-entry"><b>%A</b> = <?php _e("Uppercase Ante meridiem and Post meridiem", 'backup-backup'); ?></div>
    <div class="format-entry"><b>%B</b> = <?php _e("Swatch Internet time", 'backup-backup'); ?></div>
    <div class="format-entry"><b>%g</b> = <?php _e("12-hour format of an hour without leading zeros", 'backup-backup'); ?></div>
    <div class="format-entry"><b>%G</b> = <?php _e("24-hour format of an hour without leading zeros", 'backup-backup'); ?></div>
    <div class="format-entry"><b>%h</b> = <?php _e("12-hour format of an hour with leading zeros", 'backup-backup'); ?></div>
    <div class="format-entry"><b>%H</b> = <?php _e("24-hour format of an hour with leading zeros", 'backup-backup'); ?></div>
    <div class="format-entry"><b>%i</b> = <?php _e("Minutes with leading zeros", 'backup-backup'); ?></div>
    <div class="format-entry"><b>%s</b> = <?php _e("Seconds with leading zeros", 'backup-backup'); ?></div>
    <div class="format-entry"><b>%hash</b> = <?php _e("16 character random hash", 'backup-backup'); ?></div>
    <div class="format-entry"><b>%domain</b> = <?php _e("Current domain name of the website.", 'backup-backup'); ?><?php echo " (" . str_replace('.', '-', sanitize_text_field($domain)) . ") "; ?></div>
  </div>
  <div class="right-align">
    <a href="#" class="hoverable nodec secondary" id="hide-format-tip"><?php _e("Hide", 'backup-backup'); ?></a>
  </div>

</div>

<div class="mm mb">

  <div class="lh30">
    <div class="f20 semibold"><?php _e("Zipping", 'backup-backup'); ?></div>
    <div class="f20"><?php _e("Please select the compression method of your backup files:", 'backup-backup'); ?></div>
  </div>

  <table class="f20 mtl">
    <tbody>
      <tr>

        <td>
          <div class="lh30">

            <div class="mbll">
              <label class="container-radio">
                Zip
                <input type="radio" name="smart_exclusion_db" value="false" checked>
                <span class="checkmark-radio"></span>
              </label>
            </div>

            <div class="mbll">
              <span class="cf premium-wrapper">
                <label class="left container-radio ml25 not-allowed">
                  Tar
                  <input type="radio" disabled name="smart_exclusion_db" value="true">
                  <span class="checkmark-radio"></span>
                </label>
                <span class="left premium premium-img premium-nt"></span>
              </span>
            </div>

            <div class="">
              <span class="cf premium-wrapper">
                <label class="left container-radio ml25 not-allowed">
                  Tar GZip
                  <input type="radio" disabled name="smart_exclusion_db" value="true">
                  <span class="checkmark-radio"></span>
                </label>
                <span class="left premium premium-img premium-nt"></span>
              </span>
            </div>

          </div>
        </td>

        <td>
          <div class="f16 mw850 bol lh30">
            <i><?php _e('“ZIP” is the standard choice (compression level 1). Use “Tar” (compression level 2) or Tar.gz (compression level 5) if you want to have more compression (i.e. smaller file sizes). However, this will also put more load on the backup creation.', 'backup-backup'); ?></i>
          </div>
        </td>

      </tr>
    </tbody>
  </table>

</div>

<div class="mm mt mb overlayed">

  <?php include BMI_INCLUDES . '/dashboard/templates/premium-overlay.php'; ?>

  <div class="">
    <div class="lh30">
      <div class="f20 semibold">
        <span class="cf premium-wrapper">
          <div class="left"><?php _e("Encryption", 'backup-backup'); ?></div>
          <span class="left premium premium-img"></span>
        </span>
      </div>
      <div class="f20"><?php _e("Do you want to encrypt and password protect your files?", 'backup-backup'); ?></div>
    </div>

    <div class="mtl">
      <div class="left d-flex mr60 ia-center">
        <label class="container-radio">
          <?php _e("No", 'backup-backup'); ?>
          <input type="radio" name="" value="false" checked>
          <span class="checkmark-radio"></span>
        </label>
        <label class="left container-radio ml25 not-allowed">
          <?php _e("Yes", 'backup-backup'); ?>
          <input type="radio" disabled name="" value="true">
          <span class="checkmark-radio"></span>
        </label>
      </div>
    </div>
  </div>

</div>

<div class="mm f16 mtl mbl">
  <i><?php _e("For other security settings, e.g. who can access your backup directories, please go to the", 'backup-backup'); ?> <a href="#" class="hoverable secondary nodec collapser-openner" data-el="#other-options"><?php _e("Other options", 'backup-backup'); ?></a> <?php _e("chapter.", 'backup-backup'); ?></i>
</div>

<?php include BMI_INCLUDES . '/dashboard/chapter/save-button.php'; ?>
